/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.ExtendedSchema;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contexts")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class ContextsResource {
    public static final String apiTag = "Contexts (v1)";
    private static final Logger log = LoggerFactory.getLogger(ContextsResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public ContextsResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @GET
    @DocumentedName(value="getAllContexts")
    @Operation(summary="List contexts", description="Retrieves a list of contexts.", responses={@ApiResponse(responseCode="200", description="The contexts.", content={@Content(array=@ArraySchema(schema=@Schema(example=".")))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store. ", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Contexts (v1)")})
    @PerformanceMetric(value="contexts.list")
    public List<String> listContexts(@Parameter(description="Pagination offset for results") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Pagination size for results. Ignored if negative") @DefaultValue(value="-1") @QueryParam(value="limit") int limit) {
        try {
            limit = this.schemaRegistry.normalizeContextLimit(limit);
            List<String> contexts = this.schemaRegistry.listContexts();
            return contexts.stream().skip(offset).limit(limit).collect(Collectors.toList());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while listing contexts", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while listing contexts", e);
        }
    }

    @DELETE
    @Path(value="/{context}")
    @DocumentedName(value="deleteContext")
    @Operation(summary="Delete a context.", description="Deletes the specified context if it is empty.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not Found. Error code 40401 indicates context not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Contexts (v1)")})
    @PerformanceMetric(value="context.delete")
    public void deleteContext(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the context", required=true) @PathParam(value="context") String delimitedContext) {
        log.debug("Deleting context {}", (Object)delimitedContext);
        delimitedContext = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)delimitedContext);
        try {
            Iterator<ExtendedSchema> schemas = this.schemaRegistry.getVersionsWithSubjectPrefix(delimitedContext, false, LookupFilter.INCLUDE_DELETED, false, null);
            if (schemas.hasNext()) {
                throw Errors.contextNotEmptyException(delimitedContext);
            }
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.deleteContextOrForward(headerProperties, delimitedContext);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while deleting context", e);
        }
    }
}

