/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics.utils;

import io.confluent.kafka.multitenant.metrics.utils.MetricSampler;
import org.apache.kafka.common.utils.Time;

public class TimeIntervalMetricSampler
implements MetricSampler {
    private final Time time;
    private final long intervalNanos;
    private volatile long lastSampleTimeNanos;

    public TimeIntervalMetricSampler(Time time, long intervalNanos) {
        this.time = time;
        this.intervalNanos = intervalNanos;
        this.lastSampleTimeNanos = 0L;
    }

    @Override
    public boolean shouldSample() {
        long now = this.time.nanoseconds();
        if (this.lastSampleTimeNanos == 0L || now - this.lastSampleTimeNanos >= this.intervalNanos) {
            this.lastSampleTimeNanos = now;
            return true;
        }
        return false;
    }
}

