/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.google.crypto.tink.KmsClient;
import io.confluent.kafka.schemaregistry.encryption.azure.AzureKmsClient;
import io.confluent.kafka.schemaregistry.encryption.tink.KmsDriver;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Optional;

public class AzureKmsDriver
implements KmsDriver {
    public static final String TENANT_ID = "tenant.id";
    public static final String CLIENT_ID = "client.id";
    public static final String CLIENT_SECRET = "client.secret";

    public String getKeyUrlPrefix() {
        return "azure-kms://";
    }

    private TokenCredential getCredentials(Map<String, ?> configs) {
        String tenantId = (String)configs.get(TENANT_ID);
        String clientId = (String)configs.get(CLIENT_ID);
        String clientSecret = (String)configs.get(CLIENT_SECRET);
        if (tenantId != null && clientId != null && clientSecret != null) {
            return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(tenantId)).clientId(clientId)).clientSecret(clientSecret).build();
        }
        return new DefaultAzureCredentialBuilder().build();
    }

    public KmsClient newKmsClient(Map<String, ?> configs, Optional<String> kekUrl) throws GeneralSecurityException {
        CryptographyClient testClient = (CryptographyClient)this.getTestClient(configs);
        Optional<TokenCredential> creds = testClient != null ? Optional.empty() : Optional.of(this.getCredentials(configs));
        return AzureKmsDriver.newKmsClientWithAzureKms(kekUrl, creds, testClient);
    }

    protected static KmsClient newKmsClientWithAzureKms(Optional<String> keyUri, Optional<TokenCredential> credentials, CryptographyClient cryptographyClient) throws GeneralSecurityException {
        AzureKmsClient client = keyUri.isPresent() ? new AzureKmsClient(keyUri.get()) : new AzureKmsClient();
        if (credentials.isPresent()) {
            client.withCredentialsProvider(credentials.get());
        } else {
            client.withDefaultCredentials();
        }
        if (cryptographyClient != null) {
            client.withCryptographyClient(cryptographyClient);
        }
        return client;
    }
}

