/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.storage;

import io.confluent.dekregistry.storage.DekCacheUpdateHandler;
import io.confluent.dekregistry.storage.DekRegistry;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.dekregistry.storage.EncryptionKeyId;
import io.confluent.dekregistry.storage.KeyEncryptionKey;
import io.confluent.dekregistry.storage.KeyEncryptionKeyId;
import io.kcache.CacheUpdateHandler;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDekCacheUpdateHandler
implements DekCacheUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultDekCacheUpdateHandler.class);
    private final DekRegistry dekRegistry;

    public DefaultDekCacheUpdateHandler(DekRegistry dekRegistry) {
        this.dekRegistry = dekRegistry;
    }

    public CacheUpdateHandler.ValidationStatus validateUpdate(EncryptionKeyId key, EncryptionKey value, TopicPartition tp, long offset, long timestamp) {
        if (value != null) {
            value.setOffset(offset);
            value.setTimestamp(timestamp);
        }
        return CacheUpdateHandler.ValidationStatus.SUCCESS;
    }

    public void handleUpdate(EncryptionKeyId key, EncryptionKey value, EncryptionKey oldValue, TopicPartition tp, long offset, long timestamp) {
        String tenant = key.getTenant();
        if (value == null) {
            if (oldValue != null) {
                KeyEncryptionKey oldKek;
                this.dekRegistry.getMetricsManager().decrementKeyCount(tenant, key.getType());
                if (oldValue instanceof KeyEncryptionKey && (oldKek = (KeyEncryptionKey)oldValue).isShared()) {
                    this.dekRegistry.getSharedKeys().remove((Object)oldKek.getKmsKeyId(), (Object)((KeyEncryptionKeyId)key));
                    this.dekRegistry.getMetricsManager().decrementSharedKeyCount(tenant);
                }
            }
        } else if (oldValue == null) {
            KeyEncryptionKey kek;
            this.dekRegistry.getMetricsManager().incrementKeyCount(tenant, key.getType());
            if (value instanceof KeyEncryptionKey && (kek = (KeyEncryptionKey)value).isShared()) {
                this.dekRegistry.getSharedKeys().put((Object)kek.getKmsKeyId(), (Object)((KeyEncryptionKeyId)key));
                this.dekRegistry.getMetricsManager().incrementSharedKeyCount(tenant);
            }
        } else if (value instanceof KeyEncryptionKey && oldValue instanceof KeyEncryptionKey) {
            KeyEncryptionKey kek = (KeyEncryptionKey)value;
            KeyEncryptionKey oldKek = (KeyEncryptionKey)oldValue;
            if (!oldKek.isShared() && kek.isShared()) {
                this.dekRegistry.getSharedKeys().put((Object)kek.getKmsKeyId(), (Object)((KeyEncryptionKeyId)key));
                this.dekRegistry.getMetricsManager().incrementSharedKeyCount(tenant);
            } else if (oldKek.isShared() && !kek.isShared()) {
                this.dekRegistry.getSharedKeys().remove((Object)oldKek.getKmsKeyId(), (Object)((KeyEncryptionKeyId)key));
                this.dekRegistry.getMetricsManager().decrementSharedKeyCount(tenant);
            }
        }
    }

    public void close() {
    }
}

