/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.http.server;

import io.confluent.rest.RestConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public final class KafkaHttpServerConfig
extends RestConfig {
    public static final String HTTP_SERVER_PREFIX = "confluent.http.server.";
    public static final String METADATA_SERVER_PREFIX = "confluent.metadata.server.";
    public static final String PER_LISTENER_CONFIG_PREFIX = "listener.name.";
    public static final int PORT_DEFAULT = 8090;
    public static final String LISTENERS_DEFAULT = "http://0.0.0.0:8090";

    public static ConfigDef configDef() {
        return KafkaHttpServerConfig.baseConfigDef((int)8090, (String)LISTENERS_DEFAULT);
    }

    public KafkaHttpServerConfig(Map<String, ?> configuration) {
        this(configuration, false);
    }

    public KafkaHttpServerConfig(Map<String, ?> configuration, boolean doLog) {
        super(KafkaHttpServerConfig.configDef(), configuration, doLog);
    }

    public static KafkaHttpServerConfig scoped(Map<String, ?> configuration) {
        HashMap<String, Object> scoped = new HashMap<String, Object>();
        scoped = KafkaHttpServerConfig.assembleConfigs(scoped, KafkaHttpServerConfig.filterByAndStripPrefix(configuration, (String)HTTP_SERVER_PREFIX));
        HashMap mdsConfig = KafkaHttpServerConfig.filterByAndStripPrefix(configuration, (String)METADATA_SERVER_PREFIX);
        mdsConfig.remove("authentication.method");
        scoped = KafkaHttpServerConfig.assembleConfigs(scoped, mdsConfig);
        scoped.putIfAbsent("listeners", LISTENERS_DEFAULT);
        boolean doLog = KafkaHttpServerConfig.getBooleanOrDefault(configuration, (String)"confluent.configs.logging.enabled", (boolean)false);
        return new KafkaHttpServerConfig(scoped, doLog);
    }

    private static HashMap<String, Object> assembleConfigs(Map<String, Object> base, Map<String, Object> overrides) {
        HashMap<String, Object> assembled = new HashMap<String, Object>(base);
        Set configDefNames = KafkaHttpServerConfig.configDef().names();
        for (Map.Entry<String, Object> entry : overrides.entrySet()) {
            String baseName;
            if (entry.getKey().startsWith(PER_LISTENER_CONFIG_PREFIX)) {
                String key = entry.getKey();
                baseName = key.substring(key.indexOf(46, PER_LISTENER_CONFIG_PREFIX.length()) + 1);
            } else {
                baseName = entry.getKey();
            }
            if (!configDefNames.contains(baseName)) continue;
            if (!assembled.containsKey(entry.getKey())) {
                assembled.put(entry.getKey(), entry.getValue());
                continue;
            }
            Object baseConfigValue = assembled.get(entry.getKey());
            if (baseConfigValue == null || baseConfigValue.equals("")) {
                assembled.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() == null || entry.getValue().equals("") || entry.getValue().equals(baseConfigValue)) continue;
            throw new ConfigException(String.format("Conflicting values for configuration `%s': %s=%s and %s=%s.", entry.getKey(), entry.getKey(), baseConfigValue, entry.getKey(), entry.getValue()));
        }
        return assembled;
    }

    public boolean hasListenersConfig() {
        return !this.getList("listeners").isEmpty();
    }
}

