/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.http.server;

import io.confluent.http.server.KafkaHttpApplicationLoader;
import io.confluent.http.server.KafkaHttpServerConfig;
import io.confluent.http.server.KafkaHttpServerImpl;
import io.confluent.kafka.http.server.KafkaHttpServer;
import io.confluent.kafka.http.server.KafkaHttpServerInjector;
import io.confluent.kafka.http.server.KafkaHttpServerProvider;
import io.confluent.rest.Application;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaHttpServerProviderImpl
implements KafkaHttpServerProvider {
    private static final Logger log = LoggerFactory.getLogger(KafkaHttpApplicationLoader.class);

    public Optional<KafkaHttpServer> provide(Map<String, Object> configuration, KafkaHttpServerInjector injector) {
        KafkaHttpServerConfig scopedConfiguration = KafkaHttpServerConfig.scoped(configuration);
        if (!scopedConfiguration.hasListenersConfig()) {
            return Optional.empty();
        }
        List<Application<?>> applications = KafkaHttpApplicationLoader.load(configuration, injector);
        if (applications.isEmpty()) {
            log.info("No Kafka HTTP application configured. Not loading Kafka HTTP server.");
            return Optional.empty();
        }
        return Optional.of(new KafkaHttpServerImpl(applications, scopedConfiguration));
    }
}

