/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CellMigrationState {
    INACTIVE(0),
    PAUSED(1),
    INITIATED(2);

    private static final Map<Byte, CellMigrationState> CODE_TO_CELL_MIGRATION_STATE;
    private final byte code;

    public byte code() {
        return this.code;
    }

    private CellMigrationState(byte code) {
        this.code = code;
    }

    public static CellMigrationState toEnum(byte code) {
        if (!CODE_TO_CELL_MIGRATION_STATE.containsKey(code)) {
            throw new IllegalArgumentException(String.format("Invalid cell migration state: %s", code));
        }
        return CODE_TO_CELL_MIGRATION_STATE.get(code);
    }

    static {
        CODE_TO_CELL_MIGRATION_STATE = Arrays.stream(CellMigrationState.values()).collect(Collectors.toMap(CellMigrationState::code, Function.identity()));
    }
}

