/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class CreateDelegationTokenResponse
extends AbstractResponse {
    private final CreateDelegationTokenResponseData data;

    public CreateDelegationTokenResponse(CreateDelegationTokenResponseData data) {
        super(ApiKeys.CREATE_DELEGATION_TOKEN);
        this.data = data;
    }

    public static CreateDelegationTokenResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new CreateDelegationTokenResponse(new CreateDelegationTokenResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    public static CreateDelegationTokenResponse prepareResponse(int version, int throttleTimeMs, Errors error, KafkaPrincipal owner, KafkaPrincipal tokenRequester, long issueTimestamp, long expiryTimestamp, long maxTimestamp, String tokenId, ByteBuffer hmac) {
        CreateDelegationTokenResponseData data = new CreateDelegationTokenResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setPrincipalType(owner.getPrincipalType()).setPrincipalName(owner.getName()).setIssueTimestampMs(issueTimestamp).setExpiryTimestampMs(expiryTimestamp).setMaxTimestampMs(maxTimestamp).setTokenId(tokenId).setHmac(hmac.array());
        if (version > 2) {
            data.setTokenRequesterPrincipalType(tokenRequester.getPrincipalType()).setTokenRequesterPrincipalName(tokenRequester.getName());
        }
        return new CreateDelegationTokenResponse(data);
    }

    public static CreateDelegationTokenResponse prepareResponse(int version, int throttleTimeMs, Errors error, KafkaPrincipal owner, KafkaPrincipal requester) {
        return CreateDelegationTokenResponse.prepareResponse(version, throttleTimeMs, error, owner, requester, -1L, -1L, -1L, "", ByteBuffer.wrap(new byte[0]));
    }

    @Override
    public CreateDelegationTokenResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return CreateDelegationTokenResponse.errorCounts(this.error());
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

