/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.QueryValidator;
import io.confluent.ksql.analyzer.QueryValidatorUtil;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.util.ColumnExtractor;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.util.KsqlException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PullQueryValidator
implements QueryValidator {
    public static final String PULL_QUERY_SYNTAX_HELP = " See https://cnfl.io/queries for more info." + System.lineSeparator() + "Add EMIT CHANGES if you intended to issue a push query.";
    private static final String PULL_QUERY_LIMIT_CLAUSE_ERROR_IF_DISABLED = "LIMIT clause in pull queries is currently disabled. You can enable them by setting ksql.query.pull.limit.clause.enabled=true.";
    private static final String PULL_QUERY_LIMIT_CLAUSE_ERROR_IF_NEGATIVE = "Pull queries don't support negative integers in the LIMIT clause.";
    private static final List<Rule> RULES = ImmutableList.of((Object)Rule.of(analysis -> !analysis.getInto().isPresent(), "Pull queries don't support output to sinks."), (Object)Rule.of(analysis -> !analysis.isJoin(), "Pull queries don't support JOIN clauses."), (Object)Rule.of(analysis -> !analysis.getWindowExpression().isPresent(), "Pull queries don't support WINDOW clauses."), (Object)Rule.of(analysis -> !analysis.getGroupBy().isPresent(), "Pull queries don't support GROUP BY clauses."), (Object)Rule.of(analysis -> !analysis.getPartitionBy().isPresent(), "Pull queries don't support PARTITION BY clauses."), (Object)Rule.of(analysis -> !analysis.getHavingExpression().isPresent(), "Pull queries don't support HAVING clauses."), (Object)Rule.of(PullQueryValidator::validateLimitClause), (Object)Rule.of(analysis -> !analysis.getRefinementInfo().isPresent(), "Pull queries don't support EMIT clauses."), (Object)Rule.of(PullQueryValidator::disallowedColumnNameInSelectClause), (Object)Rule.of(PullQueryValidator::disallowedColumnNameInWhereClause));

    @Override
    public void validate(Analysis analysis) {
        try {
            RULES.forEach(rule -> rule.check(analysis));
        }
        catch (KsqlException e) {
            throw new KsqlException(e.getMessage() + PULL_QUERY_SYNTAX_HELP, (Throwable)e);
        }
        QueryValidatorUtil.validateNoUserColumnsWithSameNameAsPseudoColumns(analysis);
    }

    private static Optional<String> validateLimitClause(Analysis analysis) {
        if (!analysis.getPullLimitClauseEnabled() && analysis.getLimitClause().isPresent()) {
            return Optional.of(PULL_QUERY_LIMIT_CLAUSE_ERROR_IF_DISABLED);
        }
        if (analysis.getLimitClause().isPresent() && analysis.getLimitClause().getAsInt() < 0) {
            return Optional.of(PULL_QUERY_LIMIT_CLAUSE_ERROR_IF_NEGATIVE);
        }
        return Optional.empty();
    }

    private static Optional<String> disallowedColumnNameInSelectClause(Analysis analysis) {
        String disallowedColumns = analysis.getSelectItems().stream().filter(col -> col instanceof SingleColumn).map(SingleColumn.class::cast).map(SingleColumn::getExpression).map(ColumnExtractor::extractColumns).flatMap(Collection::stream).map(ColumnReferenceExp::getColumnName).filter(SystemColumns::isDisallowedInPullOrScalablePushQueries).map(Name::toString).collect(Collectors.joining(", "));
        if (disallowedColumns.length() != 0) {
            String message = "Pull queries don't support the following columns in SELECT clauses: " + disallowedColumns + "\n";
            return Optional.of(message);
        }
        return Optional.empty();
    }

    private static Optional<String> disallowedColumnNameInWhereClause(Analysis analysis) {
        Optional<Expression> expression = analysis.getWhereExpression();
        if (!expression.isPresent()) {
            return Optional.empty();
        }
        String disallowedColumns = ColumnExtractor.extractColumns((Expression)expression.get()).stream().map(ColumnReferenceExp::getColumnName).filter(SystemColumns::isDisallowedInPullOrScalablePushQueries).map(Name::toString).collect(Collectors.joining(", "));
        if (disallowedColumns.length() != 0) {
            String message = "Pull queries don't support the following columns in WHERE clauses: " + disallowedColumns + "\n";
            return Optional.of(message);
        }
        return Optional.empty();
    }

    private static final class Rule {
        private final Function<Analysis, Optional<String>> potentialErrorMessageGenerator;

        private static Rule of(Predicate<Analysis> condition, String failureMsg) {
            Function<Analysis, Optional<String>> potentialErrorMessageGenerator = analysis -> !condition.test((Analysis)analysis) ? Optional.of(failureMsg) : Optional.empty();
            return new Rule(potentialErrorMessageGenerator);
        }

        private static Rule of(Function<Analysis, Optional<String>> potentialErrorMessageGenerator) {
            return new Rule(potentialErrorMessageGenerator);
        }

        private Rule(Function<Analysis, Optional<String>> potentialErrorMessageGenerator) {
            this.potentialErrorMessageGenerator = Objects.requireNonNull(potentialErrorMessageGenerator, "potentialErrorMessageGenerator");
        }

        public void check(Analysis analysis) {
            Optional<String> exceptionMessage = this.potentialErrorMessageGenerator.apply(analysis);
            if (exceptionMessage.isPresent()) {
                throw new KsqlException(exceptionMessage.get());
            }
        }
    }
}

