/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.QueryValidator;
import io.confluent.ksql.analyzer.QueryValidatorUtil;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.util.KsqlException;

public class PushQueryValidator
implements QueryValidator {
    @Override
    public void validate(Analysis analysis) {
        PushQueryValidator.failPersistentQueryOnWindowedTable(analysis);
        QueryValidatorUtil.validateNoUserColumnsWithSameNameAsPseudoColumns(analysis);
    }

    private static void failPersistentQueryOnWindowedTable(Analysis analysis) {
        if (!analysis.getInto().isPresent()) {
            return;
        }
        if (analysis.getAllDataSources().stream().anyMatch(PushQueryValidator::isWindowedTable)) {
            throw new KsqlException("KSQL does not support persistent queries on windowed tables.");
        }
    }

    private static boolean isWindowedTable(Analysis.AliasedDataSource dataSource) {
        return dataSource.getDataSource().getDataSourceType() == DataSource.DataSourceType.KTABLE && dataSource.getDataSource().getKsqlTopic().getKeyFormat().isWindowed();
    }
}

