/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.connect.supported;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import io.confluent.ksql.connect.Connector;
import io.confluent.ksql.connect.supported.SupportedConnector;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.rest.entity.ConnectorInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.ValueToKey;

public final class JdbcSource
implements SupportedConnector {
    static final String JDBC_SOURCE_CLASS = "io.confluent.connect.jdbc.JdbcSourceConnector";

    @Override
    public Optional<Connector> fromConnectInfo(ConnectorInfo info) {
        Map properties = info.config();
        return this.fromConfigs(properties);
    }

    @VisibleForTesting
    Optional<Connector> fromConfigs(Map<String, String> properties) {
        String name = properties.get("name");
        return Optional.of(new Connector(name, DataSource.DataSourceType.KTABLE, JdbcSource.extractKeyNameFromSmt(properties).orElse(null)));
    }

    @Override
    public Map<String, String> resolveConfigs(Map<String, String> configs) {
        HashMap<String, String> resolved = new HashMap<String, String>(configs);
        String key = (String)resolved.remove("key");
        if (key != null) {
            resolved.merge("transforms", "ksqlCreateKey,ksqlExtractString", (a, b) -> String.join((CharSequence)",", a, b));
            resolved.put("transforms.ksqlCreateKey.type", ValueToKey.class.getName());
            resolved.put("transforms.ksqlCreateKey.fields", key);
            resolved.put("transforms.ksqlExtractString.type", ExtractField.Key.class.getName());
            resolved.put("transforms.ksqlExtractString.field", key);
        }
        resolved.putIfAbsent("tasks.max", "1");
        return resolved;
    }

    private static Optional<String> extractKeyNameFromSmt(Map<String, String> properties) {
        String transformsString = properties.get("transforms");
        if (transformsString == null) {
            return Optional.empty();
        }
        List transforms = Splitter.on((char)',').splitToList((CharSequence)transformsString);
        for (String transform : transforms) {
            String transformType = properties.get("transforms." + transform + ".type");
            if (transformType == null || !transformType.contains("ExtractField$Key")) continue;
            return Optional.ofNullable(properties.get("transforms." + transform + ".field"));
        }
        return Optional.empty();
    }
}

