/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.ddl.commands.AlterSourceFactory;
import io.confluent.ksql.ddl.commands.CreateSourceFactory;
import io.confluent.ksql.ddl.commands.DdlCommandFactory;
import io.confluent.ksql.ddl.commands.DropSourceFactory;
import io.confluent.ksql.ddl.commands.DropTypeFactory;
import io.confluent.ksql.ddl.commands.RegisterTypeFactory;
import io.confluent.ksql.execution.ddl.commands.AlterSourceCommand;
import io.confluent.ksql.execution.ddl.commands.CreateStreamCommand;
import io.confluent.ksql.execution.ddl.commands.CreateTableCommand;
import io.confluent.ksql.execution.ddl.commands.DdlCommand;
import io.confluent.ksql.execution.ddl.commands.DropSourceCommand;
import io.confluent.ksql.execution.ddl.commands.DropTypeCommand;
import io.confluent.ksql.execution.ddl.commands.RegisterTypeCommand;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.parser.DropType;
import io.confluent.ksql.parser.tree.AlterSource;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.DdlStatement;
import io.confluent.ksql.parser.tree.DropStream;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.parser.tree.RegisterType;
import io.confluent.ksql.planner.plan.KsqlStructuredDataOutputNode;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.HandlerMaps;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.Optional;

public class CommandFactories
implements DdlCommandFactory {
    private static final HandlerMaps.ClassHandlerMapR2<DdlStatement, CommandFactories, CallInfo, DdlCommand> FACTORIES = HandlerMaps.forClass(DdlStatement.class).withArgTypes(CommandFactories.class, CallInfo.class).withReturnType(DdlCommand.class).put(CreateStream.class, CommandFactories::handleCreateStream).put(CreateTable.class, CommandFactories::handleCreateTable).put(DropStream.class, CommandFactories::handleDropStream).put(DropTable.class, CommandFactories::handleDropTable).put(RegisterType.class, CommandFactories::handleRegisterType).put(DropType.class, CommandFactories::handleDropType).put(AlterSource.class, CommandFactories::handleAlterSource).build();
    private final CreateSourceFactory createSourceFactory;
    private final DropSourceFactory dropSourceFactory;
    private final RegisterTypeFactory registerTypeFactory;
    private final DropTypeFactory dropTypeFactory;
    private final AlterSourceFactory alterSourceFactory;

    public CommandFactories(ServiceContext serviceContext, MetaStore metaStore) {
        this(new CreateSourceFactory(serviceContext, metaStore), new DropSourceFactory(metaStore), new RegisterTypeFactory(metaStore), new DropTypeFactory(metaStore), new AlterSourceFactory(metaStore));
    }

    @VisibleForTesting
    CommandFactories(CreateSourceFactory createSourceFactory, DropSourceFactory dropSourceFactory, RegisterTypeFactory registerTypeFactory, DropTypeFactory dropTypeFactory, AlterSourceFactory alterSourceFactory) {
        this.createSourceFactory = Objects.requireNonNull(createSourceFactory, "createSourceFactory");
        this.dropSourceFactory = Objects.requireNonNull(dropSourceFactory, "dropSourceFactory");
        this.registerTypeFactory = Objects.requireNonNull(registerTypeFactory, "registerTypeFactory");
        this.dropTypeFactory = Objects.requireNonNull(dropTypeFactory, "dropTypeFactory");
        this.alterSourceFactory = Objects.requireNonNull(alterSourceFactory, "alterSourceFactory");
    }

    @Override
    public DdlCommand create(String sqlExpression, DdlStatement ddlStatement, SessionConfig config) {
        return (DdlCommand)FACTORIES.getOrDefault(ddlStatement.getClass(), (statement, cf, ci) -> {
            throw new KsqlException("Unable to find ddl command factory for statement:" + String.valueOf(statement.getClass()) + " valid statements:" + String.valueOf(FACTORIES.keySet()));
        }).handle((Object)this, (Object)new CallInfo(sqlExpression, config), (Object)ddlStatement);
    }

    @Override
    public DdlCommand create(KsqlStructuredDataOutputNode outputNode, Optional<RefinementInfo> emitStrategy) {
        if (outputNode.getNodeOutputType() == DataSource.DataSourceType.KSTREAM) {
            return this.createSourceFactory.createStreamCommand(outputNode);
        }
        return this.createSourceFactory.createTableCommand(outputNode, emitStrategy);
    }

    private CreateStreamCommand handleCreateStream(CallInfo callInfo, CreateStream statement) {
        return this.createSourceFactory.createStreamCommand(statement, callInfo.config.getConfig(true));
    }

    private CreateTableCommand handleCreateTable(CallInfo callInfo, CreateTable statement) {
        return this.createSourceFactory.createTableCommand(statement, callInfo.config.getConfig(true));
    }

    private DropSourceCommand handleDropStream(DropStream statement) {
        return this.dropSourceFactory.create(statement);
    }

    private DropSourceCommand handleDropTable(DropTable statement) {
        return this.dropSourceFactory.create(statement);
    }

    private RegisterTypeCommand handleRegisterType(RegisterType statement) {
        return this.registerTypeFactory.create(statement);
    }

    private DropTypeCommand handleDropType(DropType statement) {
        return this.dropTypeFactory.create(statement);
    }

    private AlterSourceCommand handleAlterSource(AlterSource statement) {
        return this.alterSourceFactory.create(statement);
    }

    private static final class CallInfo {
        final String sqlExpression;
        final SessionConfig config;

        private CallInfo(String sqlExpression, SessionConfig config) {
            this.sqlExpression = Objects.requireNonNull(sqlExpression, "sqlExpression");
            this.config = Objects.requireNonNull(config, "config");
        }
    }
}

