/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import io.confluent.ksql.execution.ddl.commands.CreateStreamCommand;
import io.confluent.ksql.execution.ddl.commands.CreateTableCommand;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.streams.timestamp.TimestampExtractionPolicyFactory;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.properties.with.SourcePropertiesUtil;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.TableElements;
import io.confluent.ksql.planner.plan.KsqlStructuredDataOutputNode;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.GenericKeySerDe;
import io.confluent.ksql.serde.GenericRowSerDe;
import io.confluent.ksql.serde.KeySerdeFactory;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.SerdeFeaturesFactory;
import io.confluent.ksql.serde.ValueSerdeFactory;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.Optional;

public final class CreateSourceFactory {
    private final ServiceContext serviceContext;
    private final SerdeFeaturessSupplier keySerdeFeaturesSupplier;
    private final SerdeFeaturessSupplier valueSerdeFeaturesSupplier;
    private final KeySerdeFactory keySerdeFactory;
    private final ValueSerdeFactory valueSerdeFactory;
    private final MetaStore metaStore;

    public CreateSourceFactory(ServiceContext serviceContext, MetaStore metaStore) {
        this(serviceContext, (s, f, e, k) -> SerdeFeaturesFactory.buildKeyFeatures(s, f), SerdeFeaturesFactory::buildValueFeatures, (KeySerdeFactory)new GenericKeySerDe(), (ValueSerdeFactory)new GenericRowSerDe(), metaStore);
    }

    @VisibleForTesting
    CreateSourceFactory(ServiceContext serviceContext, SerdeFeaturessSupplier keySerdeFeaturesSupplier, SerdeFeaturessSupplier valueSerdeFeaturesSupplier, KeySerdeFactory keySerdeFactory, ValueSerdeFactory valueSerdeFactory, MetaStore metaStore) {
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.keySerdeFeaturesSupplier = Objects.requireNonNull(keySerdeFeaturesSupplier, "keySerdeFeaturesSupplier");
        this.valueSerdeFeaturesSupplier = Objects.requireNonNull(valueSerdeFeaturesSupplier, "valueSerdeFeaturesSupplier");
        this.keySerdeFactory = Objects.requireNonNull(keySerdeFactory, "keySerdeFactory");
        this.valueSerdeFactory = Objects.requireNonNull(valueSerdeFactory, "valueSerdeFactory");
        this.metaStore = Objects.requireNonNull(metaStore);
    }

    public CreateStreamCommand createStreamCommand(KsqlStructuredDataOutputNode outputNode) {
        return new CreateStreamCommand(outputNode.getSinkName().get(), outputNode.getSchema(), outputNode.getTimestampColumn(), outputNode.getKsqlTopic().getKafkaTopicName(), Formats.from((KsqlTopic)outputNode.getKsqlTopic()), outputNode.getKsqlTopic().getKeyFormat().getWindowInfo(), Optional.of(outputNode.getOrReplace()), Optional.of(false));
    }

    public CreateStreamCommand createStreamCommand(CreateStream statement, KsqlConfig ksqlConfig) {
        SourceName sourceName = statement.getName();
        CreateSourceProperties props = statement.getProperties();
        String topicName = CreateSourceFactory.ensureTopicExists(props, this.serviceContext);
        LogicalSchema schema = CreateSourceFactory.buildSchema(statement.getElements());
        Optional<TimestampColumn> timestampColumn = CreateSourceFactory.buildTimestampColumn(ksqlConfig, props, schema);
        DataSource dataSource = this.metaStore.getSource(sourceName);
        if (dataSource != null && !statement.isOrReplace() && !statement.isNotExists()) {
            String sourceType = dataSource.getDataSourceType().getKsqlType();
            throw new KsqlException(String.format("Cannot add stream '%s': A %s with the same name already exists", sourceName.text(), sourceType.toLowerCase()));
        }
        this.throwIfCreateOrReplaceOnSourceStreamOrTable((CreateSource)statement, dataSource);
        return new CreateStreamCommand(sourceName, schema, timestampColumn, topicName, this.buildFormats(statement.getName(), schema, props, ksqlConfig), CreateSourceFactory.getWindowInfo(props), Optional.of(statement.isOrReplace()), Optional.of(statement.isSource()));
    }

    public CreateTableCommand createTableCommand(KsqlStructuredDataOutputNode outputNode, Optional<RefinementInfo> emitStrategy) {
        Optional<WindowInfo> windowInfo = outputNode.getKsqlTopic().getKeyFormat().getWindowInfo();
        if (windowInfo.isPresent() && emitStrategy.isPresent()) {
            WindowInfo info = (WindowInfo)windowInfo.get();
            windowInfo = Optional.of(WindowInfo.of((WindowType)info.getType(), (Optional)info.getSize(), Optional.of(emitStrategy.get().getOutputRefinement())));
        }
        return new CreateTableCommand(outputNode.getSinkName().get(), outputNode.getSchema(), outputNode.getTimestampColumn(), outputNode.getKsqlTopic().getKafkaTopicName(), Formats.from((KsqlTopic)outputNode.getKsqlTopic()), windowInfo, Optional.of(outputNode.getOrReplace()), Optional.of(false));
    }

    public CreateTableCommand createTableCommand(CreateTable statement, KsqlConfig ksqlConfig) {
        SourceName sourceName = statement.getName();
        CreateSourceProperties props = statement.getProperties();
        String topicName = CreateSourceFactory.ensureTopicExists(props, this.serviceContext);
        LogicalSchema schema = CreateSourceFactory.buildSchema(statement.getElements());
        DataSource dataSource = this.metaStore.getSource(sourceName);
        if (dataSource != null && !statement.isOrReplace() && !statement.isNotExists()) {
            String sourceType = dataSource.getDataSourceType().getKsqlType();
            throw new KsqlException(String.format("Cannot add table '%s': A %s with the same name already exists", sourceName.text(), sourceType.toLowerCase()));
        }
        if (schema.key().isEmpty()) {
            boolean usingSchemaInference = props.getValueSchemaId().isPresent();
            String additional = usingSchemaInference ? System.lineSeparator() + "Use a partial schema to define the primary key and still load the value columns from the Schema Registry, for example:" + System.lineSeparator() + "\tCREATE TABLE " + sourceName.text() + " (ID INT PRIMARY KEY) WITH (...);" : "";
            throw new KsqlException("Tables require a PRIMARY KEY. Please define the PRIMARY KEY." + additional);
        }
        this.throwIfCreateOrReplaceOnSourceStreamOrTable((CreateSource)statement, dataSource);
        Optional<TimestampColumn> timestampColumn = CreateSourceFactory.buildTimestampColumn(ksqlConfig, props, schema);
        return new CreateTableCommand(sourceName, schema, timestampColumn, topicName, this.buildFormats(statement.getName(), schema, props, ksqlConfig), CreateSourceFactory.getWindowInfo(props), Optional.of(statement.isOrReplace()), Optional.of(statement.isSource()));
    }

    private void throwIfCreateOrReplaceOnSourceStreamOrTable(CreateSource createSource, DataSource existingSource) {
        if (createSource.isOrReplace()) {
            String createSourceType;
            String string = createSourceType = createSource instanceof CreateStream ? "stream" : "table";
            if (createSource.isSource() || existingSource != null && existingSource.isSource()) {
                throw new KsqlException(String.format("Cannot add %s '%s': CREATE OR REPLACE is not supported on source %s.", createSourceType, createSource.getName().text(), createSourceType + "s"));
            }
        }
    }

    private Formats buildFormats(SourceName name, LogicalSchema schema, CreateSourceProperties props, KsqlConfig ksqlConfig) {
        FormatInfo keyFormat = SourcePropertiesUtil.getKeyFormat((CreateSourceProperties)props, (SourceName)name);
        FormatInfo valueFormat = SourcePropertiesUtil.getValueFormat((CreateSourceProperties)props);
        SerdeFeatures keyFeatures = this.keySerdeFeaturesSupplier.build(schema, FormatFactory.of((FormatInfo)keyFormat), SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]), ksqlConfig);
        SerdeFeatures valFeatures = this.valueSerdeFeaturesSupplier.build(schema, FormatFactory.of((FormatInfo)valueFormat), props.getValueSerdeFeatures(), ksqlConfig);
        Formats formats = Formats.of((FormatInfo)keyFormat, (FormatInfo)valueFormat, (SerdeFeatures)keyFeatures, (SerdeFeatures)valFeatures);
        this.validateSerdesCanHandleSchemas(ksqlConfig, schema, formats);
        return formats;
    }

    private static LogicalSchema buildSchema(TableElements tableElements) {
        if (Iterables.isEmpty((Iterable)tableElements)) {
            throw new KsqlException("The statement does not define any columns.");
        }
        tableElements.forEach(e -> {
            if (SystemColumns.isSystemColumn((ColumnName)e.getName())) {
                throw new KsqlException("'" + e.getName().text() + "' is a reserved column name. You cannot use it as a name for a column.");
            }
        });
        return tableElements.toLogicalSchema();
    }

    private static Optional<WindowInfo> getWindowInfo(CreateSourceProperties props) {
        return props.getWindowType().map(type -> WindowInfo.of((WindowType)type, (Optional)props.getWindowSize(), Optional.empty()));
    }

    private static String ensureTopicExists(CreateSourceProperties properties, ServiceContext serviceContext) {
        String kafkaTopicName = properties.getKafkaTopic();
        if (!serviceContext.getTopicClient().isTopicExists(kafkaTopicName)) {
            throw new KsqlException("Kafka topic does not exist: " + kafkaTopicName);
        }
        return kafkaTopicName;
    }

    private static Optional<TimestampColumn> buildTimestampColumn(KsqlConfig ksqlConfig, CreateSourceProperties properties, LogicalSchema schema) {
        Optional timestampName = properties.getTimestampColumnName();
        Optional<TimestampColumn> timestampColumn = timestampName.map(n -> new TimestampColumn(n, properties.getTimestampFormat()));
        TimestampExtractionPolicyFactory.validateTimestampColumn((KsqlConfig)ksqlConfig, (LogicalSchema)schema, timestampColumn);
        return timestampColumn;
    }

    private void validateSerdesCanHandleSchemas(KsqlConfig ksqlConfig, LogicalSchema schema, Formats formats) {
        PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)schema, (SerdeFeatures)formats.getKeyFeatures(), (SerdeFeatures)formats.getValueFeatures());
        this.keySerdeFactory.create(formats.getKeyFormat(), physicalSchema.keySchema(), ksqlConfig, this.serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty()).close();
        this.valueSerdeFactory.create(formats.getValueFormat(), physicalSchema.valueSchema(), ksqlConfig, this.serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty()).close();
    }

    @FunctionalInterface
    static interface SerdeFeaturessSupplier {
        public SerdeFeatures build(LogicalSchema var1, Format var2, SerdeFeatures var3, KsqlConfig var4);
    }
}

