/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.execution.ddl.commands.DropSourceCommand;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.tree.DropStream;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class DropSourceFactory {
    private final MetaStore metaStore;

    DropSourceFactory(MetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    public DropSourceCommand create(DropStream statement) {
        return this.create(statement.getName(), statement.getIfExists(), statement.isDeleteTopic(), DataSource.DataSourceType.KSTREAM);
    }

    public DropSourceCommand create(DropTable statement) {
        return this.create(statement.getName(), statement.getIfExists(), statement.isDeleteTopic(), DataSource.DataSourceType.KTABLE);
    }

    private DropSourceCommand create(SourceName sourceName, boolean ifExists, boolean deleteTopic, DataSource.DataSourceType dataSourceType) {
        DataSource dataSource = this.metaStore.getSource(sourceName);
        if (dataSource == null) {
            if (!ifExists) {
                String hint = this.metaStore.checkAlternatives(sourceName, Optional.of(dataSourceType));
                throw new KsqlException(StringUtils.capitalize((String)dataSourceType.getKsqlType().toLowerCase()) + " " + sourceName.text() + " does not exist." + hint);
            }
        } else {
            if (dataSource.getDataSourceType() != dataSourceType) {
                throw new KsqlException(String.format("Incompatible data source type is %s, but statement was DROP %s", dataSource.getDataSourceType().getKsqlType().toLowerCase(), dataSourceType.getKsqlType().toLowerCase()));
            }
            if (dataSource.isSource() && deleteTopic) {
                throw new KsqlException("Cannot delete topic for read-only source: " + sourceName.text());
            }
        }
        return new DropSourceCommand(sourceName);
    }
}

