/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.execution.ddl.commands.DropTypeCommand;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.DropType;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;

public class DropTypeFactory {
    private final MetaStore metaStore;

    DropTypeFactory(MetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    public DropTypeCommand create(DropType statement) {
        String typeName = statement.getTypeName();
        boolean ifExists = statement.getIfExists();
        if (!ifExists && !this.metaStore.resolveType(typeName).isPresent()) {
            throw new KsqlException("Type " + typeName + " does not exist.");
        }
        return new DropTypeCommand(typeName);
    }
}

