/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.execution.ddl.commands.RegisterTypeCommand;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.tree.RegisterType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;

public final class RegisterTypeFactory {
    private final MetaStore metaStore;

    RegisterTypeFactory(MetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    public RegisterTypeCommand create(RegisterType statement) {
        String name = statement.getName();
        boolean ifNotExists = statement.getIfNotExists();
        SqlType type = statement.getType().getSqlType();
        if (!ifNotExists && this.metaStore.resolveType(name).isPresent()) {
            throw new KsqlException("Cannot register custom type '" + name + "' since it is already registered with type: " + String.valueOf(this.metaStore.resolveType(name).get()));
        }
        return new RegisterTypeCommand(type, name);
    }
}

