/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.engine.QueryCleanupService;
import io.confluent.ksql.exception.KafkaResponseGetFailedException;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrphanedTransientQueryCleaner {
    private static final Logger LOG = LogManager.getLogger(OrphanedTransientQueryCleaner.class);
    private final QueryCleanupService cleanupService;
    private final KsqlConfig ksqlConfig;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public OrphanedTransientQueryCleaner(QueryCleanupService cleanupService, KsqlConfig ksqlConfig) {
        this.cleanupService = Objects.requireNonNull(cleanupService);
        this.ksqlConfig = ksqlConfig;
    }

    public void cleanupOrphanedInternalTopics(ServiceContext serviceContext, Set<String> queryApplicationIds) {
        Set topicNames;
        KafkaTopicClient topicClient = serviceContext.getTopicClient();
        try {
            topicNames = topicClient.listTopicNames();
        }
        catch (KafkaResponseGetFailedException e) {
            LOG.error("Couldn't fetch topic names", (Throwable)e);
            return;
        }
        Set orphanedQueryApplicationIds = topicNames.stream().map(topicName -> queryApplicationIds.stream().filter(topicName::startsWith).findFirst()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        for (String queryApplicationId : orphanedQueryApplicationIds) {
            this.cleanupService.addCleanupTask(new QueryCleanupService.QueryCleanupTask(serviceContext, queryApplicationId, Optional.empty(), true, this.ksqlConfig.getKsqlStreamConfigProps().getOrDefault("state.dir", StreamsConfig.configDef().defaultValues().get("state.dir")).toString(), this.ksqlConfig.getString("ksql.service.id"), this.ksqlConfig.getString("ksql.persistent.prefix")));
        }
    }
}

