/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.execution.expression.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.execution.expression.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.execution.expression.tree.BetweenPredicate;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.BytesLiteral;
import io.confluent.ksql.execution.expression.tree.Cast;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.CreateArrayExpression;
import io.confluent.ksql.execution.expression.tree.CreateMapExpression;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.execution.expression.tree.DateLiteral;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DereferenceExpression;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.InListExpression;
import io.confluent.ksql.execution.expression.tree.InPredicate;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.IntervalUnit;
import io.confluent.ksql.execution.expression.tree.IsNotNullPredicate;
import io.confluent.ksql.execution.expression.tree.IsNullPredicate;
import io.confluent.ksql.execution.expression.tree.LambdaFunctionCall;
import io.confluent.ksql.execution.expression.tree.LambdaVariable;
import io.confluent.ksql.execution.expression.tree.LikePredicate;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.NotExpression;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.SearchedCaseExpression;
import io.confluent.ksql.execution.expression.tree.SimpleCaseExpression;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.execution.expression.tree.SubscriptExpression;
import io.confluent.ksql.execution.expression.tree.TimeLiteral;
import io.confluent.ksql.execution.expression.tree.TimestampLiteral;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.WhenClause;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public final class ExpressionTreeRewriter<C> {
    private final RewritingVisitor<C> rewriter;

    public static <C, T extends Expression> T rewriteWith(BiFunction<Expression, Context<C>, Optional<Expression>> plugin, T expression) {
        return ExpressionTreeRewriter.rewriteWith(plugin, expression, null);
    }

    public static <C, T extends Expression> T rewriteWith(BiFunction<Expression, Context<C>, Optional<Expression>> plugin, T expression, C context) {
        return new ExpressionTreeRewriter<C>(plugin).rewrite(expression, context);
    }

    public <T extends Expression> T rewrite(T expression, C context) {
        return (T)((Expression)this.rewriter.process(expression, context));
    }

    public ExpressionTreeRewriter(BiFunction<Expression, Context<C>, Optional<Expression>> plugin) {
        this.rewriter = new RewritingVisitor<C>(plugin);
    }

    ExpressionTreeRewriter(BiFunction<Expression, Context<C>, Optional<Expression>> plugin, BiFunction<Expression, C, Expression> rewriter) {
        this.rewriter = new RewritingVisitor<C>(plugin, rewriter);
    }

    private static final class RewritingVisitor<C>
    implements ExpressionVisitor<Expression, C> {
        private final BiFunction<Expression, Context<C>, Optional<Expression>> plugin;
        private final BiFunction<Expression, C, Expression> rewriter;

        private RewritingVisitor(BiFunction<Expression, Context<C>, Optional<Expression>> plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            this.rewriter = (arg_0, arg_1) -> ((RewritingVisitor)this).process(arg_0, arg_1);
        }

        private RewritingVisitor(BiFunction<Expression, Context<C>, Optional<Expression>> plugin, BiFunction<Expression, C, Expression> rewriter) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            this.rewriter = Objects.requireNonNull(rewriter, "rewriter");
        }

        public Expression visitType(Type node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression child = this.rewriter.apply(node.getValue(), context);
            return new ArithmeticUnaryExpression(node.getLocation(), node.getSign(), child);
        }

        public Expression visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression left = this.rewriter.apply(node.getLeft(), context);
            Expression right = this.rewriter.apply(node.getRight(), context);
            return new ArithmeticBinaryExpression(node.getLocation(), node.getOperator(), left, right);
        }

        public Expression visitSubscriptExpression(SubscriptExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression base = this.rewriter.apply(node.getBase(), context);
            Expression index = this.rewriter.apply(node.getIndex(), context);
            return new SubscriptExpression(node.getLocation(), base, index);
        }

        public Expression visitCreateArrayExpression(CreateArrayExpression exp, C context) {
            ImmutableList.Builder values = ImmutableList.builder();
            for (Expression value : exp.getValues()) {
                values.add((Object)this.rewriter.apply(value, context));
            }
            return new CreateArrayExpression(exp.getLocation(), (List)values.build());
        }

        public Expression visitCreateMapExpression(CreateMapExpression exp, C context) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (Map.Entry entry : exp.getMap().entrySet()) {
                map.put((Object)this.rewriter.apply((Expression)entry.getKey(), context), (Object)this.rewriter.apply((Expression)entry.getValue(), context));
            }
            return new CreateMapExpression(exp.getLocation(), (Map)map.build());
        }

        public Expression visitStructExpression(CreateStructExpression node, C context) {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (CreateStructExpression.Field field : node.getFields()) {
                fields.add((Object)new CreateStructExpression.Field(field.getName(), this.rewriter.apply(field.getValue(), context)));
            }
            return new CreateStructExpression(node.getLocation(), (List)fields.build());
        }

        public Expression visitComparisonExpression(ComparisonExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression left = this.rewriter.apply(node.getLeft(), context);
            Expression right = this.rewriter.apply(node.getRight(), context);
            return new ComparisonExpression(node.getLocation(), node.getType(), left, right);
        }

        public Expression visitBetweenPredicate(BetweenPredicate node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression value = this.rewriter.apply(node.getValue(), context);
            Expression min = this.rewriter.apply(node.getMin(), context);
            Expression max = this.rewriter.apply(node.getMax(), context);
            return new BetweenPredicate(value, min, max);
        }

        public Expression visitLogicalBinaryExpression(LogicalBinaryExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression left = this.rewriter.apply(node.getLeft(), context);
            Expression right = this.rewriter.apply(node.getRight(), context);
            return new LogicalBinaryExpression(node.getLocation(), node.getType(), left, right);
        }

        public Expression visitNotExpression(NotExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression value = this.rewriter.apply(node.getValue(), context);
            return new NotExpression(node.getLocation(), value);
        }

        public Expression visitIsNullPredicate(IsNullPredicate node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression value = this.rewriter.apply(node.getValue(), context);
            return new IsNullPredicate(node.getLocation(), value);
        }

        public Expression visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression value = this.rewriter.apply(node.getValue(), context);
            return new IsNotNullPredicate(node.getLocation(), value);
        }

        public Expression visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)((WhenClause)this.rewriter.apply((Expression)expression, context)));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> this.rewriter.apply((Expression)value, context));
            return new SearchedCaseExpression(node.getLocation(), (List)builder.build(), defaultValue);
        }

        public Expression visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression operand = this.rewriter.apply(node.getOperand(), context);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)((WhenClause)this.rewriter.apply((Expression)expression, context)));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> this.rewriter.apply((Expression)value, context));
            return new SimpleCaseExpression(node.getLocation(), operand, (List)builder.build(), defaultValue);
        }

        public Expression visitWhenClause(WhenClause node, C context) {
            Optional<Expression> rewritten = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (rewritten.isPresent()) {
                return rewritten.get();
            }
            Expression operand = this.rewriter.apply(node.getOperand(), context);
            Expression result = this.rewriter.apply(node.getResult(), context);
            return new WhenClause(node.getLocation(), operand, result);
        }

        public Expression visitFunctionCall(FunctionCall node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            List args = node.getArguments().stream().map(arg -> this.rewriter.apply((Expression)arg, context)).collect(Collectors.toList());
            return new FunctionCall(node.getLocation(), node.getName(), args);
        }

        public Expression visitLikePredicate(LikePredicate node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression value = this.rewriter.apply(node.getValue(), context);
            Expression pattern = this.rewriter.apply(node.getPattern(), context);
            return new LikePredicate(node.getLocation(), value, pattern, node.getEscape());
        }

        public Expression visitInPredicate(InPredicate node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression value = this.rewriter.apply(node.getValue(), context);
            InListExpression list = (InListExpression)this.rewriter.apply((Expression)node.getValueList(), context);
            return new InPredicate(node.getLocation(), value, list);
        }

        public Expression visitInListExpression(InListExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Expression expression : node.getValues()) {
                builder.add((Object)this.rewriter.apply(expression, context));
            }
            return new InListExpression(node.getLocation(), (List)builder.build());
        }

        public Expression visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitQualifiedColumnReference(QualifiedColumnReferenceExp node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitDereferenceExpression(DereferenceExpression node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression base = this.rewriter.apply(node.getBase(), context);
            return new DereferenceExpression(node.getLocation(), base, node.getFieldName());
        }

        public Expression visitCast(Cast node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression expression = this.rewriter.apply(node.getExpression(), context);
            Type type = (Type)this.rewriter.apply((Expression)node.getType(), context);
            return new Cast(node.getLocation(), expression, type);
        }

        public Expression visitLambdaExpression(LambdaFunctionCall node, C context) {
            Optional<Expression> result = this.plugin.apply((Expression)node, new Context<C>(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Expression expression = this.rewriter.apply(node.getBody(), context);
            return new LambdaFunctionCall(node.getLocation(), node.getArguments(), expression);
        }

        public Expression visitBooleanLiteral(BooleanLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitDoubleLiteral(DoubleLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitIntegerLiteral(IntegerLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitLongLiteral(LongLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitLambdaVariable(LambdaVariable node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitIntervalUnit(IntervalUnit node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitNullLiteral(NullLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitStringLiteral(StringLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitDecimalLiteral(DecimalLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitTimeLiteral(TimeLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitDateLiteral(DateLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitTimestampLiteral(TimestampLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }

        public Expression visitBytesLiteral(BytesLiteral node, C context) {
            return this.plugin.apply((Expression)node, new Context<C>(context, this)).orElse((Expression)node);
        }
    }

    public static final class Context<C> {
        private final C context;
        private final ExpressionVisitor<Expression, C> rewriter;

        private Context(C context, ExpressionVisitor<Expression, C> rewriter) {
            this.context = context;
            this.rewriter = rewriter;
        }

        public C getContext() {
            return this.context;
        }

        public Expression process(Expression expression) {
            return (Expression)this.rewriter.process(expression, this.context);
        }
    }
}

