/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine.rewrite;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.AstBuilder;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.SqlBaseBaseVisitor;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.tree.ColumnConstraints;
import io.confluent.ksql.util.ParserUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;

public class QueryAnonymizer {
    public String anonymize(ParseTree tree) {
        return this.build(tree);
    }

    public String anonymize(String query) {
        SqlBaseParser.StatementsContext tree = DefaultKsqlParser.getParseTree((String)query);
        return this.build((ParseTree)tree);
    }

    private String build(ParseTree parseTree) {
        return (String)new Visitor().visit(parseTree);
    }

    private static final class Visitor
    extends SqlBaseBaseVisitor<String> {
        private int streamCount = 1;
        private int columnCount = 1;
        private int tableCount = 1;
        private int headerCount = 1;
        private int udfCount = 1;
        private int sourceCount = 1;
        private final Hashtable<String, String> anonTable = new Hashtable();

        private Visitor() {
        }

        public String visitStatements(SqlBaseParser.StatementsContext context) {
            ArrayList<String> statementList = new ArrayList<String>();
            for (SqlBaseParser.SingleStatementContext stmtContext : context.singleStatement()) {
                String statement = this.visitSingleStatement(stmtContext);
                statementList.add(statement);
            }
            return StringUtils.join(statementList, (String)"\n");
        }

        public String visitSingleStatement(SqlBaseParser.SingleStatementContext context) {
            return String.format("%s;", this.visit((ParseTree)context.statement()));
        }

        public String visitType(SqlBaseParser.TypeContext context) {
            if (context.type().isEmpty()) {
                return this.getTypeName(context);
            }
            String typeName = "STRUCT";
            if (context.MAP() != null) {
                typeName = "MAP";
            } else if (context.ARRAY() != null) {
                typeName = "ARRAY";
            }
            ArrayList<String> typeList = new ArrayList<String>();
            for (SqlBaseParser.TypeContext typeContext : context.type()) {
                typeList.add((String)this.visit((ParseTree)typeContext));
            }
            return String.format("%s<%s>", typeName, StringUtils.join(typeList, (String)", "));
        }

        public String visitAlterSource(SqlBaseParser.AlterSourceContext context) {
            StringBuilder stringBuilder = new StringBuilder("ALTER");
            String streamTable = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            if (context.STREAM() != null) {
                stringBuilder.append(String.format(" STREAM %s", this.getAnonStreamName(streamTable)));
            } else {
                stringBuilder.append(String.format(" TABLE %s", this.getAnonTableName(streamTable)));
            }
            ArrayList<String> alterOptions = new ArrayList<String>();
            for (SqlBaseParser.AlterOptionContext alterOption : context.alterOption()) {
                alterOptions.add((String)this.visit((ParseTree)alterOption));
            }
            stringBuilder.append(String.format(" (%s)", StringUtils.join(alterOptions, (String)", ")));
            return stringBuilder.toString();
        }

        public String visitAlterOption(SqlBaseParser.AlterOptionContext context) {
            String columnName = context.identifier().getText();
            String anonColumnName = this.getAnonColumnName(columnName);
            return String.format("ADD COLUMN %1$s %2$s", anonColumnName, this.visit((ParseTree)context.type()));
        }

        public String visitRegisterType(SqlBaseParser.RegisterTypeContext context) {
            StringBuilder stringBuilder = new StringBuilder("CREATE TYPE");
            if (context.EXISTS() != null) {
                stringBuilder.append(" IF NOT EXISTS");
            }
            stringBuilder.append(String.format(" type AS %s", this.visit((ParseTree)context.type())));
            return stringBuilder.toString();
        }

        public String visitCreateConnector(SqlBaseParser.CreateConnectorContext context) {
            StringBuilder stringBuilder = new StringBuilder("CREATE");
            if (context.SOURCE() != null) {
                stringBuilder.append(" SOURCE");
            } else if (context.SINK() != null) {
                stringBuilder.append(" SINK");
            }
            stringBuilder.append(" CONNECTOR");
            if (context.EXISTS() != null) {
                stringBuilder.append(" IF NOT EXISTS");
            }
            stringBuilder.append(" connector ");
            if (context.tableProperties() != null) {
                stringBuilder.append((String)this.visit((ParseTree)context.tableProperties()));
            }
            return stringBuilder.toString();
        }

        public String visitInsertInto(SqlBaseParser.InsertIntoContext context) {
            StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
            String streamName = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            stringBuilder.append(this.getAnonStreamName(streamName));
            if (context.tableProperties() != null) {
                stringBuilder.append((String)this.visit((ParseTree)context.tableProperties()));
            }
            if (context.query() != null) {
                stringBuilder.append(String.format(" %s", this.visit((ParseTree)context.query())));
            }
            return stringBuilder.toString();
        }

        public String visitInsertValues(SqlBaseParser.InsertValuesContext context) {
            StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
            String streamName = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            stringBuilder.append(this.getAnonStreamName(streamName));
            if (context.columns() != null) {
                List columns = context.columns().identifier().stream().map(ParserUtil::getIdentifierText).map(ColumnName::of).map(Name::toString).map(this::getAnonColumnName).collect(Collectors.toList());
                stringBuilder.append(String.format(" (%s)", StringUtils.join(columns, (String)", ")));
            }
            ArrayList<String> values = new ArrayList<String>();
            for (SqlBaseParser.ValueExpressionContext value : context.values().valueExpression()) {
                values.add((String)this.visit((ParseTree)value));
            }
            stringBuilder.append(String.format(" VALUES (%s)", StringUtils.join(values, (String)" ,")));
            return stringBuilder.toString();
        }

        public String visitListConnectors(SqlBaseParser.ListConnectorsContext context) {
            TerminalNode listOrVisit = context.LIST() != null ? context.LIST() : context.SHOW();
            StringBuilder stringBuilder = new StringBuilder(listOrVisit.toString());
            if (context.SOURCE() != null) {
                stringBuilder.append(" SOURCE");
            } else if (context.SINK() != null) {
                stringBuilder.append(" SINK");
            }
            stringBuilder.append(" CONNECTORS");
            return stringBuilder.toString();
        }

        public String visitListStreams(SqlBaseParser.ListStreamsContext context) {
            TerminalNode listOrVisit = context.LIST() != null ? context.LIST() : context.SHOW();
            StringBuilder stringBuilder = new StringBuilder(listOrVisit.toString() + " STREAMS");
            if (context.EXTENDED() != null) {
                stringBuilder.append(" EXTENDED");
            }
            return stringBuilder.toString();
        }

        public String visitListTables(SqlBaseParser.ListTablesContext context) {
            TerminalNode listOrVisit = context.LIST() != null ? context.LIST() : context.SHOW();
            StringBuilder stringBuilder = new StringBuilder(listOrVisit.toString() + " TABLES");
            if (context.EXTENDED() != null) {
                stringBuilder.append(" EXTENDED");
            }
            return stringBuilder.toString();
        }

        public String visitListFunctions(SqlBaseParser.ListFunctionsContext context) {
            TerminalNode listOrVisit = context.LIST() != null ? context.LIST() : context.SHOW();
            return String.format("%s FUNCTIONS", listOrVisit.toString());
        }

        public String visitListProperties(SqlBaseParser.ListPropertiesContext context) {
            TerminalNode listOrVisit = context.LIST() != null ? context.LIST() : context.SHOW();
            return String.format("%s PROPERTIES", listOrVisit.toString());
        }

        public String visitListTypes(SqlBaseParser.ListTypesContext context) {
            TerminalNode listOrVisit = context.LIST() != null ? context.LIST() : context.SHOW();
            return String.format("%s TYPES", listOrVisit.toString());
        }

        public String visitListVariables(SqlBaseParser.ListVariablesContext context) {
            TerminalNode listOrVisit = context.LIST() != null ? context.LIST() : context.SHOW();
            return String.format("%s VARIABLES", listOrVisit.toString());
        }

        public String visitListQueries(SqlBaseParser.ListQueriesContext context) {
            TerminalNode listOrVisit = context.LIST() != null ? context.LIST() : context.SHOW();
            StringBuilder stringBuilder = new StringBuilder(listOrVisit.toString() + " QUERIES");
            if (context.EXTENDED() != null) {
                stringBuilder.append(" EXTENDED");
            }
            return stringBuilder.toString();
        }

        public String visitListTopics(SqlBaseParser.ListTopicsContext context) {
            TerminalNode listOrVisit = context.LIST() != null ? context.LIST() : context.SHOW();
            StringBuilder stringBuilder = new StringBuilder(listOrVisit.toString());
            if (context.ALL() != null) {
                stringBuilder.append(" ALL");
            }
            stringBuilder.append(" TOPICS");
            if (context.EXTENDED() != null) {
                stringBuilder.append(" EXTENDED");
            }
            return stringBuilder.toString();
        }

        public String visitDescribeFunction(SqlBaseParser.DescribeFunctionContext context) {
            return "DESCRIBE FUNCTION function";
        }

        public String visitDescribeConnector(SqlBaseParser.DescribeConnectorContext context) {
            return "DESCRIBE CONNECTOR connector";
        }

        public String visitPrintTopic(SqlBaseParser.PrintTopicContext context) {
            StringBuilder stringBuilder = new StringBuilder("PRINT topic");
            if (context.printClause().FROM() != null) {
                stringBuilder.append(" FROM BEGINNING");
            }
            if (context.printClause().intervalClause() != null) {
                stringBuilder.append(" INTERVAL '0'");
            }
            if (context.printClause().limitClause() != null) {
                stringBuilder.append(" LIMIT '0'");
            }
            return stringBuilder.toString();
        }

        public String visitTerminateQuery(SqlBaseParser.TerminateQueryContext context) {
            if (context.ALL() != null) {
                return "TERMINATE ALL";
            }
            return "TERMINATE query";
        }

        public String visitDescribeStreams(SqlBaseParser.DescribeStreamsContext context) {
            StringBuilder stringBuilder = new StringBuilder("DESCRIBE STREAMS ");
            if (context.EXTENDED() != null) {
                stringBuilder.append("EXTENDED");
            }
            return stringBuilder.toString();
        }

        public String visitShowColumns(SqlBaseParser.ShowColumnsContext context) {
            StringBuilder stringBuilder = new StringBuilder("DESCRIBE ");
            String streamTable = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            if (context.sourceName().identifier() instanceof SqlBaseParser.UnquotedIdentifierContext && context.sourceName().getText().equalsIgnoreCase("TABLES")) {
                stringBuilder.append(this.getAnonTableName(streamTable));
            } else {
                stringBuilder.append(this.getAnonStreamName(streamTable));
            }
            if (context.EXTENDED() != null) {
                stringBuilder.append(" EXTENDED");
            }
            return stringBuilder.toString();
        }

        public String visitSetProperty(SqlBaseParser.SetPropertyContext context) {
            String propertyName = context.STRING(0).getText();
            return String.format("SET %s='[string]'", propertyName);
        }

        public String visitAlterSystemProperty(SqlBaseParser.AlterSystemPropertyContext context) {
            String propertyName = context.STRING(0).getText();
            return String.format("ALTER SYSTEM %s='[string]'", propertyName);
        }

        public String visitUnsetProperty(SqlBaseParser.UnsetPropertyContext context) {
            String propertyName = context.STRING().getText();
            return String.format("UNSET %s", propertyName);
        }

        public String visitDefineVariable(SqlBaseParser.DefineVariableContext context) {
            return "DEFINE variable='[string]'";
        }

        public String visitUndefineVariable(SqlBaseParser.UndefineVariableContext context) {
            return "UNDEFINE variable";
        }

        public String visitExplain(SqlBaseParser.ExplainContext context) {
            if (context.identifier() != null) {
                return "EXPLAIN query";
            }
            String subQuery = (String)this.visit((ParseTree)context.statement());
            return String.format("EXPLAIN %s", subQuery);
        }

        public String visitExpression(SqlBaseParser.ExpressionContext context) {
            String columnName = context.getText();
            if (new AstBuilder(TypeRegistry.EMPTY).buildExpression((ParserRuleContext)context) instanceof FunctionCall) {
                return this.getAnonUdfName(columnName);
            }
            return this.getAnonColumnName(columnName);
        }

        public String visitSelectSingle(SqlBaseParser.SelectSingleContext context) {
            return (String)this.visit((ParseTree)context.expression());
        }

        public String visitSingleExpression(SqlBaseParser.SingleExpressionContext context) {
            return (String)this.visit((ParseTree)context.expression());
        }

        public String visitBooleanDefault(SqlBaseParser.BooleanDefaultContext context) {
            String columnName = context.getChild(0).getChild(0).getText();
            String anonColumnName = this.getAnonColumnName(columnName);
            if (context.getChild(0).getChild(1) != null) {
                String anonValue = (String)this.visit(context.getChild(0).getChild(1));
                return String.format("%1$s=%2$s", anonColumnName, anonValue);
            }
            return anonColumnName;
        }

        public String visitLogicalBinary(SqlBaseParser.LogicalBinaryContext context) {
            return String.format("%1$s %2$s %3$s", this.visit((ParseTree)context.left), context.operator.getText(), this.visit((ParseTree)context.right));
        }

        public String visitPartitionBy(SqlBaseParser.PartitionByContext context) {
            String columnName = context.getText();
            return this.getAnonColumnName(columnName);
        }

        public String visitGroupBy(SqlBaseParser.GroupByContext context) {
            String columnName = context.getText();
            return this.getAnonColumnName(columnName);
        }

        public String visitStringLiteral(SqlBaseParser.StringLiteralContext context) {
            return "'[string]'";
        }

        public String visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext context) {
            return "'0'";
        }

        public String visitNumericLiteral(SqlBaseParser.NumericLiteralContext context) {
            return "'0'";
        }

        public String visitBooleanLiteral(SqlBaseParser.BooleanLiteralContext context) {
            return "'false'";
        }

        public String visitCreateStreamAs(SqlBaseParser.CreateStreamAsContext context) {
            StringBuilder stringBuilder = new StringBuilder("CREATE ");
            if (context.OR() != null && context.REPLACE() != null) {
                stringBuilder.append("OR REPLACE ");
            }
            stringBuilder.append("STREAM ");
            if (context.IF() != null && context.NOT() != null && context.EXISTS() != null) {
                stringBuilder.append("IF NOT EXISTS ");
            }
            String streamName = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            stringBuilder.append(this.getAnonStreamName(streamName));
            if (context.tableProperties() != null) {
                stringBuilder.append((String)this.visit((ParseTree)context.tableProperties()));
            }
            if (context.query() != null) {
                stringBuilder.append(String.format(" AS %s", this.visit((ParseTree)context.query())));
            }
            return stringBuilder.toString();
        }

        public String visitCreateStream(SqlBaseParser.CreateStreamContext context) {
            StringBuilder stringBuilder = new StringBuilder("CREATE ");
            if (context.SOURCE() != null) {
                stringBuilder.append("SOURCE ");
            }
            if (context.OR() != null && context.REPLACE() != null) {
                stringBuilder.append("OR REPLACE ");
            }
            stringBuilder.append("STREAM ");
            if (context.IF() != null && context.NOT() != null && context.EXISTS() != null) {
                stringBuilder.append("IF NOT EXISTS ");
            }
            String streamName = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            stringBuilder.append(String.format("%s ", this.getAnonStreamName(streamName)));
            if (context.tableElements() != null) {
                stringBuilder.append((String)this.visit((ParseTree)context.tableElements()));
            }
            if (context.tableProperties() != null) {
                stringBuilder.append((String)this.visit((ParseTree)context.tableProperties()));
            }
            return stringBuilder.toString();
        }

        public String visitCreateTableAs(SqlBaseParser.CreateTableAsContext context) {
            StringBuilder stringBuilder = new StringBuilder("CREATE ");
            if (context.OR() != null && context.REPLACE() != null) {
                stringBuilder.append("OR REPLACE ");
            }
            stringBuilder.append("TABLE ");
            if (context.IF() != null && context.NOT() != null && context.EXISTS() != null) {
                stringBuilder.append("IF NOT EXISTS ");
            }
            String tableName = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            stringBuilder.append(this.getAnonTableName(tableName));
            if (context.tableProperties() != null) {
                stringBuilder.append((String)this.visit((ParseTree)context.tableProperties()));
            }
            if (context.query() != null) {
                stringBuilder.append(String.format(" AS %s", this.visit((ParseTree)context.query())));
            }
            return stringBuilder.toString();
        }

        public String visitCreateTable(SqlBaseParser.CreateTableContext context) {
            StringBuilder stringBuilder = new StringBuilder("CREATE ");
            if (context.SOURCE() != null) {
                stringBuilder.append("SOURCE ");
            }
            if (context.OR() != null && context.REPLACE() != null) {
                stringBuilder.append("OR REPLACE ");
            }
            stringBuilder.append("TABLE ");
            if (context.IF() != null && context.NOT() != null && context.EXISTS() != null) {
                stringBuilder.append("IF NOT EXISTS ");
            }
            String tableName = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            stringBuilder.append(String.format("%s ", this.getAnonTableName(tableName)));
            if (context.tableElements() != null) {
                stringBuilder.append((String)this.visit((ParseTree)context.tableElements()));
            }
            if (context.tableProperties() != null) {
                stringBuilder.append((String)this.visit((ParseTree)context.tableProperties()));
            }
            return stringBuilder.toString();
        }

        public String visitTableElements(SqlBaseParser.TableElementsContext context) {
            ArrayList<String> tableElements = new ArrayList<String>();
            for (SqlBaseParser.TableElementContext tableContext : context.tableElement()) {
                tableElements.add((String)this.visit((ParseTree)tableContext));
            }
            return String.format("(%s) ", StringUtils.join(tableElements, (String)", "));
        }

        public String visitTableElement(SqlBaseParser.TableElementContext context) {
            StringBuilder stringBuilder = new StringBuilder();
            String columnName = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.identifier());
            String newName = this.getAnonColumnName(columnName);
            stringBuilder.append(String.format("%1$s %2$s", newName, this.visit((ParseTree)context.type())));
            ColumnConstraints constraints = ParserUtil.getColumnConstraints((SqlBaseParser.ColumnConstraintsContext)context.columnConstraints());
            if (constraints.isPrimaryKey()) {
                stringBuilder.append(" PRIMARY KEY");
            } else if (constraints.isKey()) {
                stringBuilder.append(" KEY");
            } else if (constraints.isHeaders()) {
                if (constraints.getHeaderKey().isPresent()) {
                    stringBuilder.append(" HEADER('").append(this.getAnonHeaderName((String)constraints.getHeaderKey().get())).append("')");
                } else {
                    stringBuilder.append(" HEADERS");
                }
            }
            return stringBuilder.toString();
        }

        public String visitTableProperties(SqlBaseParser.TablePropertiesContext context) {
            ArrayList<String> tableProperties = new ArrayList<String>();
            for (SqlBaseParser.TablePropertyContext prop : context.tableProperty()) {
                StringBuilder formattedProp = new StringBuilder();
                if (prop.identifier() != null) {
                    formattedProp.append(ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)prop.identifier()));
                } else {
                    formattedProp.append(prop.STRING().getText());
                }
                formattedProp.append("=").append((String)this.visit((ParseTree)prop.literal()));
                tableProperties.add(formattedProp.toString());
            }
            return String.format("WITH (%s)", StringUtils.join(tableProperties, (String)", "));
        }

        public String visitDropTable(SqlBaseParser.DropTableContext context) {
            StringBuilder stringBuilder = new StringBuilder("DROP TABLE ");
            if (context.EXISTS() != null) {
                stringBuilder.append("IF EXISTS ");
            }
            String tableName = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            stringBuilder.append(this.getAnonTableName(tableName));
            if (context.DELETE() != null) {
                stringBuilder.append(" DELETE TOPIC");
            }
            return stringBuilder.toString();
        }

        public String visitDropStream(SqlBaseParser.DropStreamContext context) {
            StringBuilder stringBuilder = new StringBuilder("DROP STREAM ");
            if (context.EXISTS() != null) {
                stringBuilder.append("IF EXISTS ");
            }
            String streamName = ParserUtil.getIdentifierText((SqlBaseParser.IdentifierContext)context.sourceName().identifier());
            stringBuilder.append(this.getAnonStreamName(streamName));
            if (context.DELETE() != null) {
                stringBuilder.append(" DELETE TOPIC");
            }
            return stringBuilder.toString();
        }

        public String visitDropConnector(SqlBaseParser.DropConnectorContext context) {
            StringBuilder stringBuilder = new StringBuilder("DROP CONNECTOR ");
            if (context.EXISTS() != null) {
                stringBuilder.append("IF EXISTS ");
            }
            stringBuilder.append("connector");
            return stringBuilder.toString();
        }

        public String visitDropType(SqlBaseParser.DropTypeContext context) {
            StringBuilder stringBuilder = new StringBuilder("DROP TYPE ");
            if (context.EXISTS() != null) {
                stringBuilder.append("IF EXISTS ");
            }
            stringBuilder.append("type");
            return stringBuilder.toString();
        }

        public String visitQuery(SqlBaseParser.QueryContext context) {
            StringBuilder stringBuilder = new StringBuilder("SELECT ");
            ArrayList<String> selectItemList = new ArrayList<String>();
            for (SqlBaseParser.SelectItemContext selectItem : context.selectItem()) {
                if (selectItem.getText().equals("*")) {
                    selectItemList.add("*");
                    continue;
                }
                selectItemList.add((String)this.visit((ParseTree)selectItem));
            }
            stringBuilder.append(StringUtils.join(selectItemList, (String)", "));
            stringBuilder.append(String.format(" FROM %s", this.visit((ParseTree)context.from)));
            if (context.where != null) {
                stringBuilder.append(String.format(" WHERE %s", this.visit((ParseTree)context.where)));
            }
            if (context.partitionBy() != null) {
                stringBuilder.append(String.format(" PARTITION BY %s", this.visit((ParseTree)context.partitionBy())));
            }
            if (context.groupBy() != null) {
                stringBuilder.append(String.format(" GROUP BY %s", this.visit((ParseTree)context.groupBy())));
            }
            if (context.EMIT() != null) {
                stringBuilder.append(" EMIT CHANGES");
            }
            return stringBuilder.toString();
        }

        public String visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
            return (String)this.visit((ParseTree)context.relationPrimary());
        }

        public String visitRelationDefault(SqlBaseParser.RelationDefaultContext context) {
            return this.getAnonSourceName(context.getText());
        }

        public String visitTableName(SqlBaseParser.TableNameContext context) {
            return this.getAnonSourceName(context.getText());
        }

        public String visitJoinRelation(SqlBaseParser.JoinRelationContext context) {
            String left = (String)this.visit((ParseTree)context.left);
            ImmutableList rights = (ImmutableList)context.joinedSource().stream().map(this::visitJoinedSource).collect(ImmutableList.toImmutableList());
            return String.format("%s %s", left, String.join((CharSequence)" ", (Iterable<? extends CharSequence>)rights));
        }

        public String visitJoinedSource(SqlBaseParser.JoinedSourceContext context) {
            StringBuilder stringBuilder = new StringBuilder();
            SqlBaseParser.JoinTypeContext joinTypeContext = context.joinType();
            if (joinTypeContext instanceof SqlBaseParser.LeftJoinContext) {
                stringBuilder.append("LEFT OUTER ");
            } else if (joinTypeContext instanceof SqlBaseParser.OuterJoinContext) {
                stringBuilder.append("FULL OUTER ");
            } else {
                stringBuilder.append("INNER ");
            }
            String right = (String)this.visit((ParseTree)context.aliasedRelation());
            stringBuilder.append(String.format("JOIN %s", right));
            if (context.joinWindow() != null) {
                stringBuilder.append(Visitor.visitWithinExpression(context.joinWindow().withinExpression()));
            }
            stringBuilder.append("ON anonKey1=anonKey2");
            return stringBuilder.toString();
        }

        private static String visitWithinExpression(SqlBaseParser.WithinExpressionContext context) {
            StringBuilder stringBuilder = new StringBuilder(" WITHIN ");
            if (context instanceof SqlBaseParser.SingleJoinWindowContext) {
                SqlBaseParser.SingleJoinWindowContext singleWithin = (SqlBaseParser.SingleJoinWindowContext)context;
                stringBuilder.append(String.format("%s", Visitor.anonymizeJoinWindowSize(singleWithin.joinWindowSize())));
                if (singleWithin.gracePeriodClause() != null) {
                    stringBuilder.append(String.format(" GRACE PERIOD %s", Visitor.anonymizeGracePeriod(singleWithin.gracePeriodClause())));
                }
            } else if (context instanceof SqlBaseParser.JoinWindowWithBeforeAndAfterContext) {
                SqlBaseParser.JoinWindowWithBeforeAndAfterContext beforeAndAfterJoinWindow = (SqlBaseParser.JoinWindowWithBeforeAndAfterContext)context;
                stringBuilder.append(String.format("(%s, %s)", Visitor.anonymizeJoinWindowSize(beforeAndAfterJoinWindow.joinWindowSize(0)), Visitor.anonymizeJoinWindowSize(beforeAndAfterJoinWindow.joinWindowSize(1))));
                if (beforeAndAfterJoinWindow.gracePeriodClause() != null) {
                    stringBuilder.append(String.format(" GRACE PERIOD %s", Visitor.anonymizeGracePeriod(beforeAndAfterJoinWindow.gracePeriodClause())));
                }
            } else {
                throw new RuntimeException("Expecting either a single join window, ie \"WITHIN 10 seconds\" or \"WITHIN 10 seconds GRACE PERIOD 2 seconds\", or a join window with before and after specified, ie. \"WITHIN (10 seconds, 20 seconds)\" or WITHIN (10 seconds, 20 seconds) GRACE PERIOD 5 seconds");
            }
            return stringBuilder.append(' ').toString();
        }

        private static String anonymizeGracePeriod(SqlBaseParser.GracePeriodClauseContext gracePeriodClause) {
            return String.format("'0' %s", gracePeriodClause.windowUnit().getText().toUpperCase());
        }

        private static String anonymizeJoinWindowSize(SqlBaseParser.JoinWindowSizeContext joinWindowSize) {
            return String.format("'0' %s", joinWindowSize.windowUnit().getText().toUpperCase());
        }

        private String getTypeName(SqlBaseParser.TypeContext context) {
            if (context.DECIMAL() != null) {
                return "DECIMAL";
            }
            switch (context.getText().toUpperCase()) {
                case "BOOLEAN": 
                case "INTEGER": 
                case "INT": 
                case "BIGINT": 
                case "DOUBLE": 
                case "STRING": 
                case "VARCHAR": 
                case "BYTES": {
                    return context.getText().toUpperCase();
                }
            }
            return "CUSTOM_TYPE";
        }

        private String getAnonSourceName(String originName) {
            return this.getAnonName(originName, "source", this.sourceCount++);
        }

        private String getAnonUdfName(String originName) {
            return this.getAnonName(originName, "udf", this.udfCount++);
        }

        private String getAnonStreamName(String originName) {
            return this.getAnonName(originName, "stream", this.streamCount++);
        }

        private String getAnonColumnName(String originName) {
            return this.getAnonName(originName, "column", this.columnCount++);
        }

        private String getAnonTableName(String originName) {
            return this.getAnonName(originName, "table", this.tableCount++);
        }

        private String getAnonHeaderName(String originName) {
            return this.getAnonName(originName, "header", this.headerCount++);
        }

        private String getAnonName(String originName, String genericName, int count) {
            if (this.anonTable.containsKey(originName + genericName)) {
                return this.anonTable.get(originName + genericName);
            }
            String newName = String.format("%s%d", genericName, count);
            this.anonTable.put(originName + genericName, newName);
            return newName;
        }
    }
}

