/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine.rewrite;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.execution.expression.tree.BetweenPredicate;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.execution.expression.tree.VisitParentExpressionVisitor;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.util.timestamp.PartialStringToTimestampParser;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class StatementRewriteForMagicPseudoTimestamp {
    private static final Set<ColumnName> SUPPORTED_COLUMNS = ImmutableSet.builder().addAll((Iterable)SystemColumns.windowBoundsColumnNames()).add((Object)SystemColumns.ROWTIME_NAME).build();
    private final PartialStringToTimestampParser parser;

    public StatementRewriteForMagicPseudoTimestamp() {
        this(new PartialStringToTimestampParser());
    }

    @VisibleForTesting
    StatementRewriteForMagicPseudoTimestamp(PartialStringToTimestampParser parser) {
        this.parser = Objects.requireNonNull(parser, "parser");
    }

    public Expression rewrite(Expression expression) {
        return new ExpressionTreeRewriter<Object>((arg_0, arg_1) -> ((OperatorPlugin)new OperatorPlugin()).process(arg_0, arg_1)).rewrite(expression, null);
    }

    private static boolean noRewriteRequired(Expression expression) {
        return !expression.toString().contains("ROWTIME");
    }

    private Optional<Expression> maybeRewriteTimestamp(Expression maybeTimestamp) {
        if (!(maybeTimestamp instanceof StringLiteral)) {
            return Optional.empty();
        }
        String text = ((StringLiteral)maybeTimestamp).getValue();
        return Optional.of(new LongLiteral(this.parser.parse(text)));
    }

    private static boolean supportedColumnRef(Expression maybeColumnRef) {
        if (!(maybeColumnRef instanceof ColumnReferenceExp)) {
            return false;
        }
        return SUPPORTED_COLUMNS.contains(((ColumnReferenceExp)maybeColumnRef).getColumnName());
    }

    private final class OperatorPlugin
    extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> {
        private OperatorPlugin() {
            super(Optional.empty());
        }

        public Optional<Expression> visitBetweenPredicate(BetweenPredicate node, ExpressionTreeRewriter.Context<Void> context) {
            if (!StatementRewriteForMagicPseudoTimestamp.supportedColumnRef(node.getValue())) {
                return Optional.empty();
            }
            Optional<Expression> min = StatementRewriteForMagicPseudoTimestamp.this.maybeRewriteTimestamp(node.getMin());
            Optional<Expression> max = StatementRewriteForMagicPseudoTimestamp.this.maybeRewriteTimestamp(node.getMax());
            if (!min.isPresent() && !max.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(new BetweenPredicate(node.getLocation(), node.getValue(), min.orElse(node.getMin()), max.orElse(node.getMax())));
        }

        public Optional<Expression> visitComparisonExpression(ComparisonExpression node, ExpressionTreeRewriter.Context<Void> context) {
            if (StatementRewriteForMagicPseudoTimestamp.supportedColumnRef(node.getLeft())) {
                Optional<Expression> right = StatementRewriteForMagicPseudoTimestamp.this.maybeRewriteTimestamp(node.getRight());
                return right.map(r -> new ComparisonExpression(node.getLocation(), node.getType(), node.getLeft(), r));
            }
            if (StatementRewriteForMagicPseudoTimestamp.supportedColumnRef(node.getRight())) {
                Optional<Expression> left = StatementRewriteForMagicPseudoTimestamp.this.maybeRewriteTimestamp(node.getLeft());
                return left.map(l -> new ComparisonExpression(node.getLocation(), node.getType(), l, node.getRight()));
            }
            return Optional.empty();
        }
    }
}

