/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.plan.StreamSelect;
import io.confluent.ksql.execution.plan.StreamSource;
import io.confluent.ksql.execution.streams.ExecutionStepFactory;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.physicalplanner.nodes.Node;
import io.confluent.ksql.physicalplanner.nodes.NodeVisitor;
import io.confluent.ksql.physicalplanner.nodes.SelectNode;
import io.confluent.ksql.physicalplanner.nodes.StreamSourceNode;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PhysicalToExecutionPlanTranslator
implements NodeVisitor<Node<?>, ExecutionStep<?>> {
    private final MetaStore metaStore;

    PhysicalToExecutionPlanTranslator(MetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    @Override
    public ExecutionStep<?> process(Node<?> node) {
        if (node instanceof StreamSourceNode) {
            return this.processStreamSourceNode((StreamSourceNode)node);
        }
        if (node instanceof SelectNode) {
            return this.processSelectNode((SelectNode)node);
        }
        throw new IllegalStateException("Unknown node type: " + String.valueOf(node.getClass()));
    }

    private StreamSource processStreamSourceNode(StreamSourceNode streamSourceNode) {
        return ExecutionStepFactory.streamSource((QueryContext.Stacker)new QueryContext.Stacker().push(new String[]{"SOURCE"}), (LogicalSchema)streamSourceNode.getSimpleSchema(), (String)this.metaStore.getSource(streamSourceNode.getSourceName()).getKsqlTopic().getKafkaTopicName(), (Formats)streamSourceNode.getFormats(), Optional.empty(), (int)1);
    }

    private StreamSelect<GenericKey> processSelectNode(SelectNode selectNode) {
        ExecutionStep<?> inputStep = this.process(selectNode.getInputNode());
        List selectExpressions = (List)selectNode.valueColumnNames().stream().map(columnName -> SelectExpression.of((ColumnName)columnName, (Expression)new UnqualifiedColumnReferenceExp(columnName))).collect(ImmutableList.toImmutableList());
        return ExecutionStepFactory.streamSelect((QueryContext.Stacker)new QueryContext.Stacker().push(new String[]{"SELECT"}), inputStep, selectNode.getInputNode().keyColumnNames(), Optional.of(selectNode.keyColumnNames()), (List)selectExpressions);
    }
}

