/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.common.operators;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.execution.common.QueryRowImpl;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.common.operators.PhysicalOperatorUtil;
import io.confluent.ksql.execution.common.operators.UnaryPhysicalOperator;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.execution.transform.select.SelectValueMapper;
import io.confluent.ksql.execution.transform.select.SelectValueMapperFactory;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.QueryProjectNode;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ProjectOperator
extends AbstractPhysicalOperator
implements UnaryPhysicalOperator {
    private final ProcessingLogger logger;
    private final SelectValueMapperFactory.SelectValueMapperFactorySupplier selectValueMapperFactorySupplier;
    private final QueryProjectNode logicalNode;
    private AbstractPhysicalOperator child;
    private KsqlTransformer<Object, GenericRow> transformer;

    public ProjectOperator(ProcessingLogger logger, QueryProjectNode logicalNode) {
        this(logger, logicalNode, SelectValueMapperFactory::create);
    }

    @VisibleForTesting
    ProjectOperator(ProcessingLogger logger, QueryProjectNode logicalNode, SelectValueMapperFactory.SelectValueMapperFactorySupplier selectValueMapperFactorySupplier) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.logicalNode = Objects.requireNonNull(logicalNode, "logicalNode");
        this.selectValueMapperFactorySupplier = selectValueMapperFactorySupplier;
    }

    @Override
    public void open() {
        this.child.open();
        if (this.logicalNode.getIsSelectStar()) {
            return;
        }
        SelectValueMapper select = this.selectValueMapperFactorySupplier.create(this.logicalNode.getSelectExpressions(), this.logicalNode.getCompiledSelectExpressions());
        this.transformer = select.getTransformer(this.logger);
    }

    @Override
    public Object next() {
        QueryRow row = (QueryRow)this.child.next();
        if (row == null) {
            return null;
        }
        if (row.getOffsetRange().isPresent()) {
            return row;
        }
        GenericRow intermediate = PhysicalOperatorUtil.getIntermediateRow(row, this.logicalNode.getAddAdditionalColumnsToIntermediateSchema());
        if (this.logicalNode.getIsSelectStar()) {
            return QueryRowImpl.of(this.logicalNode.getSchema(), GenericKey.genericKey((Object[])new Object[0]), Optional.empty(), GenericRow.fromList(this.createRowForSelectStar(intermediate)), row.rowTime());
        }
        GenericRow mapped = (GenericRow)this.transformer.transform((Object)row.key(), intermediate);
        ProjectOperator.validateProjection(mapped, this.logicalNode.getSchema());
        return QueryRowImpl.of(this.logicalNode.getSchema(), GenericKey.genericKey((Object[])new Object[0]), Optional.empty(), GenericRow.fromList((List)mapped.values()), row.rowTime());
    }

    @Override
    public void close() {
        this.child.close();
    }

    @Override
    public PlanNode getLogicalNode() {
        return this.logicalNode;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public void addChild(AbstractPhysicalOperator child) {
        if (this.child != null) {
            throw new UnsupportedOperationException("The project operator already has a child.");
        }
        Objects.requireNonNull(child, "child");
        this.child = child;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AbstractPhysicalOperator getChild() {
        return this.child;
    }

    @Override
    public AbstractPhysicalOperator getChild(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractPhysicalOperator> getChildren() {
        throw new UnsupportedOperationException();
    }

    private static void validateProjection(GenericRow fullRow, LogicalSchema schema) {
        int expected;
        int actual = fullRow.size();
        if (actual != (expected = schema.columns().size())) {
            throw new IllegalStateException("Row column count mismatch. expected:" + expected + ", got:" + actual);
        }
    }

    private List<?> createRowForSelectStar(GenericRow intermediate) {
        ArrayList<Object> rowList = new ArrayList<Object>();
        for (SelectExpression selectExpression : this.logicalNode.getSelectExpressions()) {
            Optional column = this.logicalNode.getIntermediateSchema().findValueColumn(selectExpression.getAlias());
            if (!column.isPresent()) {
                throw new IllegalStateException("Couldn't find alias in intermediate schema " + String.valueOf(selectExpression.getAlias()));
            }
            int i = ((Column)column.get()).index();
            rowList.add(intermediate.get(i));
        }
        return rowList;
    }
}

