/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush;

import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.query.QueryId;
import java.util.ArrayDeque;
import java.util.Deque;

public class ProcessingQueue {
    static final int BLOCKING_QUEUE_CAPACITY = 1000;
    private final Deque<QueryRow> rowQueue;
    private final QueryId queryId;
    private final int queueSizeLimit;
    private boolean closed = false;
    private boolean droppedRows = false;
    private boolean hasError = false;
    private Runnable newRowCallback = () -> {};

    public ProcessingQueue(QueryId queryId) {
        this(queryId, 1000);
    }

    public ProcessingQueue(QueryId queryId, int queueSizeLimit) {
        this.queryId = queryId;
        this.queueSizeLimit = queueSizeLimit;
        this.rowQueue = new ArrayDeque<QueryRow>();
    }

    public synchronized boolean offer(QueryRow queryRow) {
        if (this.closed) {
            return false;
        }
        if (this.rowQueue.size() < this.queueSizeLimit && !this.droppedRows) {
            this.rowQueue.offer(queryRow);
            this.newRowCallback.run();
            return true;
        }
        this.droppedRows = true;
        return false;
    }

    public synchronized QueryRow poll() {
        if (!this.closed) {
            return this.rowQueue.poll();
        }
        return null;
    }

    public synchronized void close() {
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void setNewRowCallback(Runnable newRowCallback) {
        this.newRowCallback = newRowCallback;
    }

    public synchronized boolean hasDroppedRows() {
        return this.droppedRows;
    }

    public synchronized void onError() {
        this.hasError = true;
    }

    public synchronized boolean getHasError() {
        return this.hasError;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public synchronized boolean isAtLimit() {
        return this.rowQueue.size() >= this.queueSizeLimit;
    }
}

