/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush;

import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.common.operators.ProjectOperator;
import io.confluent.ksql.execution.common.operators.SelectOperator;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.context.QueryLoggerUtil;
import io.confluent.ksql.execution.scalablepush.PushPhysicalPlan;
import io.confluent.ksql.execution.scalablepush.ScalablePushRegistry;
import io.confluent.ksql.execution.scalablepush.operators.PeekStreamOperator;
import io.confluent.ksql.execution.scalablepush.operators.PushDataSourceOperator;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.planner.LogicalPlanNode;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.KsqlBareOutputNode;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.QueryFilterNode;
import io.confluent.ksql.planner.plan.QueryProjectNode;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.PushOffsetRange;
import io.vertx.core.Context;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class PushPhysicalPlanBuilder {
    private static final String REGISTRY_NOT_FOUND_ERROR_MESSAGE = "Scalable push registry cannot be found. Make sure that ksql.query.push.v2.registry.installed is set to true.";
    private final ProcessingLogContext processingLogContext;
    private final PersistentQueryMetadata persistentQueryMetadata;
    private final QueryContext.Stacker contextStacker;
    private final QueryId queryId;
    private KsqlConstants.QuerySourceType querySourceType;

    public PushPhysicalPlanBuilder(ProcessingLogContext processingLogContext, PersistentQueryMetadata persistentQueryMetadata) {
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
        this.persistentQueryMetadata = Objects.requireNonNull(persistentQueryMetadata, "persistentQueryMetadata");
        this.contextStacker = new QueryContext.Stacker();
        this.queryId = this.uniqueQueryId();
    }

    public PushPhysicalPlan buildPushPhysicalPlan(LogicalPlanNode logicalPlanNode, Context context, Optional<PushOffsetRange> offsetRange, Optional<String> catchupConsumerGroup) {
        String catchupConsumerGroupId = this.getConsumerGroupId(catchupConsumerGroup);
        PushDataSourceOperator dataSourceOperator = null;
        OutputNode outputNode = logicalPlanNode.getNode().orElseThrow(() -> new IllegalArgumentException("Need an output node to build a plan"));
        if (!(outputNode instanceof KsqlBareOutputNode)) {
            throw new KsqlException("Push queries expect the root of the logical plan to be a KsqlBareOutputNode.");
        }
        PlanNode currentLogicalNode = outputNode.getSource();
        AbstractPhysicalOperator prevPhysicalOp = null;
        AbstractPhysicalOperator rootPhysicalOp = null;
        while (true) {
            AbstractPhysicalOperator currentPhysicalOp = null;
            if (currentLogicalNode instanceof QueryProjectNode) {
                currentPhysicalOp = this.translateProjectNode((QueryProjectNode)currentLogicalNode);
            } else if (currentLogicalNode instanceof QueryFilterNode) {
                currentPhysicalOp = this.translateFilterNode((QueryFilterNode)currentLogicalNode);
            } else if (currentLogicalNode instanceof DataSourceNode) {
                currentPhysicalOp = this.translateDataSourceNode((DataSourceNode)currentLogicalNode, offsetRange, catchupConsumerGroupId);
                dataSourceOperator = (PushDataSourceOperator)((Object)currentPhysicalOp);
            } else {
                throw new KsqlException(String.format("Error in translating logical to physical plan for scalable push queries: unrecognized logical node %s.", currentLogicalNode));
            }
            if (prevPhysicalOp == null) {
                rootPhysicalOp = currentPhysicalOp;
            } else {
                prevPhysicalOp.addChild(currentPhysicalOp);
            }
            prevPhysicalOp = currentPhysicalOp;
            if (currentLogicalNode.getSources().isEmpty()) break;
            if (currentLogicalNode.getSources().size() > 1) {
                throw new KsqlException("Push queries do not support joins or nested sub-queries yet.");
            }
            currentLogicalNode = currentLogicalNode.getSources().get(0);
        }
        if (dataSourceOperator == null) {
            throw new IllegalStateException("DataSourceOperator cannot be null in Push physical plan");
        }
        return new PushPhysicalPlan(rootPhysicalOp, rootPhysicalOp.getLogicalNode().getSchema(), this.queryId, catchupConsumerGroupId, dataSourceOperator.getScalablePushRegistry(), dataSourceOperator, context, this.querySourceType);
    }

    private ProjectOperator translateProjectNode(QueryProjectNode logicalNode) {
        ProcessingLogger logger = this.processingLogContext.getLoggerFactory().getLogger(QueryLoggerUtil.queryLoggerName((QueryLoggerUtil.QueryType)QueryLoggerUtil.QueryType.PULL_QUERY, (QueryContext)this.contextStacker.push(new String[]{"PROJECT"}).getQueryContext()));
        return new ProjectOperator(logger, logicalNode);
    }

    private SelectOperator translateFilterNode(QueryFilterNode logicalNode) {
        ProcessingLogger logger = this.processingLogContext.getLoggerFactory().getLogger(QueryLoggerUtil.queryLoggerName((QueryLoggerUtil.QueryType)QueryLoggerUtil.QueryType.PULL_QUERY, (QueryContext)this.contextStacker.push(new String[]{"SELECT"}).getQueryContext()));
        return new SelectOperator(logicalNode, logger);
    }

    private AbstractPhysicalOperator translateDataSourceNode(DataSourceNode logicalNode, Optional<PushOffsetRange> offsetRange, String catchupConsumerGroupId) {
        ScalablePushRegistry scalablePushRegistry = this.persistentQueryMetadata.getScalablePushRegistry().orElseThrow(() -> new IllegalStateException(REGISTRY_NOT_FOUND_ERROR_MESSAGE));
        this.querySourceType = logicalNode.isWindowed() ? KsqlConstants.QuerySourceType.WINDOWED : KsqlConstants.QuerySourceType.NON_WINDOWED;
        Optional<ScalablePushRegistry.CatchupMetadata> catchupMetadata = offsetRange.map(or -> new ScalablePushRegistry.CatchupMetadata((PushOffsetRange)or, catchupConsumerGroupId));
        return new PeekStreamOperator(scalablePushRegistry, logicalNode, this.queryId, catchupMetadata);
    }

    private String getConsumerGroupId(Optional<String> catchupConsumerGroupFromSource) {
        ScalablePushRegistry scalablePushRegistry = this.persistentQueryMetadata.getScalablePushRegistry().orElseThrow(() -> new IllegalStateException(REGISTRY_NOT_FOUND_ERROR_MESSAGE));
        return catchupConsumerGroupFromSource.orElse(scalablePushRegistry.getCatchupConsumerId(UUID.randomUUID().toString()));
    }

    private QueryId uniqueQueryId() {
        return new QueryId("SCALABLE_PUSH_QUERY_" + String.valueOf(UUID.randomUUID()));
    }
}

