/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush.consumer;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsumerMetadata
implements AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(ConsumerMetadata.class);
    private final int numPartitions;

    public ConsumerMetadata(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    public void close() {
    }

    public static ConsumerMetadata create(String topicName, KafkaConsumer<?, GenericRow> consumer) {
        Map partitionInfo = consumer.listTopics();
        if (!partitionInfo.containsKey(topicName)) {
            throw new KsqlException("Can't find expected topic " + topicName);
        }
        int numPartitions = ((List)partitionInfo.get(topicName)).size();
        return new ConsumerMetadata(numPartitions);
    }

    public static interface ConsumerMetadataFactory {
        public ConsumerMetadata create(String var1, KafkaConsumer<?, GenericRow> var2);
    }
}

