/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.format;

import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.SqlFormatter;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import java.util.Optional;

public class DefaultFormatInjector
implements Injector {
    @Override
    public <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement) {
        if (statement.getStatement() instanceof CreateSource) {
            return this.handleCreateSource(statement);
        }
        return statement;
    }

    private <T extends Statement> ConfiguredStatement<T> handleCreateSource(ConfiguredStatement<CreateSource> statement) {
        try {
            ConfiguredStatement<CreateSource> injected = this.injectForCreateStatement(statement).orElse(statement);
            return injected;
        }
        catch (KsqlStatementException e) {
            throw e;
        }
        catch (KsqlException e) {
            throw new KsqlStatementException(e.getMessage(), statement.getMaskedStatementText(), e.getCause());
        }
    }

    private Optional<ConfiguredStatement<CreateSource>> injectForCreateStatement(ConfiguredStatement<CreateSource> original) {
        CreateSource statement = original.getStatement();
        CreateSourceProperties properties = statement.getProperties();
        Optional keyFormat = properties.getKeyFormat(statement.getName());
        Optional valueFormat = properties.getValueFormat();
        if (keyFormat.isPresent() && valueFormat.isPresent()) {
            return Optional.empty();
        }
        KsqlConfig config = DefaultFormatInjector.getConfig(original);
        CreateSourceProperties injectedProps = properties.withFormats(keyFormat.map(FormatInfo::getFormat).orElseGet(() -> DefaultFormatInjector.getDefaultKeyFormat(config)), valueFormat.map(FormatInfo::getFormat).orElseGet(() -> DefaultFormatInjector.getDefaultValueFormat(config)));
        CreateSource withFormats = statement.copyWith(original.getStatement().getElements(), injectedProps);
        KsqlParser.PreparedStatement<CreateSource> prepared = DefaultFormatInjector.buildPreparedStatement(withFormats);
        ConfiguredStatement<CreateSource> configured = ConfiguredStatement.of(prepared, original.getSessionConfig());
        return Optional.of(configured);
    }

    private static KsqlConfig getConfig(ConfiguredStatement<?> statement) {
        return statement.getSessionConfig().getConfig(true);
    }

    private static String getDefaultKeyFormat(KsqlConfig config) {
        String format = config.getString("ksql.persistence.default.format.key");
        if (format == null) {
            throw new KsqlException("Statement is missing the 'KEY_FORMAT' property from the WITH clause. Either provide one or set a default via the 'ksql.persistence.default.format.key' config.");
        }
        return format;
    }

    private static String getDefaultValueFormat(KsqlConfig config) {
        String format = config.getString("ksql.persistence.default.format.value");
        if (format == null) {
            throw new KsqlException("Statement is missing the 'VALUE_FORMAT' property from the WITH clause. Either provide one or set a default via the 'ksql.persistence.default.format.value' config.");
        }
        return format;
    }

    private static KsqlParser.PreparedStatement<CreateSource> buildPreparedStatement(CreateSource stmt) {
        return KsqlParser.PreparedStatement.of((String)SqlFormatter.formatSql((AstNode)stmt), (Statement)stmt);
    }
}

