/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.FunctionInvoker;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.UdafTypes;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;

public class DynamicFunctionInvoker
implements FunctionInvoker {
    private final Method method;

    DynamicFunctionInvoker(Method method) {
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (method.getParameterTypes()[i].isArray() && (!method.isVarArgs() || i != method.getParameterCount() - 1)) {
                throw new KsqlFunctionException("Invalid function method signature (contains non var-arg array): " + String.valueOf(method));
            }
            if (method.getGenericParameterTypes()[i] instanceof TypeVariable || method.getGenericParameterTypes()[i] instanceof GenericArrayType) continue;
            Class<?> type = types[i];
            UdafTypes.checkSupportedType(method, type);
        }
        this.method = method;
    }

    public Object eval(Object udf, Object ... args) {
        try {
            Object[] extractedArgs = this.extractArgs(args);
            return this.method.invoke(udf, extractedArgs);
        }
        catch (Exception e) {
            throw new KsqlFunctionException("Failed to invoke function " + String.valueOf(this.method), (Throwable)e);
        }
    }

    private Object[] extractArgs(Object ... source) {
        if (!this.method.isVarArgs()) {
            return source;
        }
        Object[] args = new Object[this.method.getParameterCount()];
        System.arraycopy(source, 0, args, 0, this.method.getParameterCount() - 1);
        int start = this.method.getParameterCount() - 1;
        Class<?> componentType = this.method.getParameterTypes()[start].getComponentType();
        Object val = Array.newInstance(componentType, source.length - start);
        for (int i = start; i < source.length; ++i) {
            Array.set(val, i - start, source[i]);
        }
        args[start] = val;
        return args;
    }
}

