/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.function.AggregateFunctionFactory;
import io.confluent.ksql.function.AggregateFunctionInitArguments;
import io.confluent.ksql.function.FunctionSignature;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.UdafFactoryInvoker;
import io.confluent.ksql.function.UdfIndex;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class UdafAggregateFunctionFactory
extends AggregateFunctionFactory {
    private final UdfIndex<UdafFactoryInvoker> udfIndex;

    UdafAggregateFunctionFactory(UdfMetadata metadata, List<UdafFactoryInvoker> factoryList) {
        this(metadata, (UdfIndex<UdafFactoryInvoker>)new UdfIndex(metadata.getName(), false));
        factoryList.forEach(arg_0 -> this.udfIndex.addFunction(arg_0));
    }

    @VisibleForTesting
    UdafAggregateFunctionFactory(UdfMetadata metadata, UdfIndex<UdafFactoryInvoker> index) {
        super(metadata);
        this.udfIndex = Objects.requireNonNull(index);
    }

    public synchronized AggregateFunctionFactory.FunctionSource getFunction(List<SqlType> argTypeList) {
        List args = argTypeList.stream().map(type -> type == null ? null : SqlArgument.of((SqlType)type)).collect(Collectors.toList());
        UdafFactoryInvoker creator = (UdafFactoryInvoker)this.udfIndex.getFunction(args);
        if (creator == null) {
            throw new KsqlException("There is no aggregate function with name='" + this.getName() + "' that has arguments of type=" + argTypeList.stream().map(SqlType::baseType).map(Objects::toString).collect(Collectors.joining(",")));
        }
        boolean isFactoryVariadic = creator.literalParams().stream().anyMatch(ParameterInfo::isVariadic);
        int numSignatureInitArgs = creator.literalParams().size();
        int numInitArgs = isFactoryVariadic ? argTypeList.size() - (creator.parameterInfo().size() - numSignatureInitArgs) : numSignatureInitArgs;
        return new AggregateFunctionFactory.FunctionSource(numInitArgs, initArgs -> creator.createFunction((AggregateFunctionInitArguments)initArgs, args));
    }

    public synchronized List<List<ParamType>> supportedArgs() {
        return this.udfIndex.values().stream().map(UdafFactoryInvoker::parameters).collect(Collectors.toList());
    }

    public void eachFunction(BiConsumer<FunctionSignature, String> consumer) {
        this.udfIndex.values().forEach(invoker -> consumer.accept((FunctionSignature)invoker, invoker.getDescription()));
    }
}

