/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.execution.codegen.helpers.TriFunction;
import io.confluent.ksql.execution.function.UdfUtil;
import io.confluent.ksql.function.FunctionLoaderUtils;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.udaf.VariadicArgs;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.Quadruple;
import io.confluent.ksql.util.Quintuple;
import io.confluent.ksql.util.Triple;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.connect.data.Struct;

class UdafTypes {
    private static final Set<Class<?>> SUPPORTED_TYPES = ImmutableSet.builder().add(Integer.TYPE).add(Long.TYPE).add(Double.TYPE).add(Boolean.TYPE).add(Integer.class).add(Long.class).add(Double.class).add(BigDecimal.class).add(Boolean.class).add(String.class).add(Struct.class).add(List.class).add(Map.class).add(Date.class).add(Time.class).add(Timestamp.class).add(TimeUnit.class).add(Function.class).add(BiFunction.class).add(TriFunction.class).add(ByteBuffer.class).build();
    private static final ImmutableSet<Type> TUPLE_TYPES = ImmutableSet.builder().add(Pair.class).add(Triple.class).add(Quadruple.class).add(Quintuple.class).build();
    private static final Type VARIADIC_TYPE = VariadicArgs.class;
    private final boolean isVariadic;
    final int variadicColIndex;
    private final Type[] inputTypes;
    private final Type aggregateType;
    private final Type outputType;
    private final List<ParameterInfo> literalParams;
    private final String invalidClassErrorMsg;
    private final SqlTypeParser sqlTypeParser;

    UdafTypes(Method method, FunctionName functionName, SqlTypeParser sqlTypeParser) {
        boolean objArgIsNotVariadic;
        this.invalidClassErrorMsg = "class='%s' is not supported by UDAFs. Valid types are: " + String.valueOf(SUPPORTED_TYPES) + " " + String.valueOf(Objects.requireNonNull(functionName, "functionName"));
        AnnotatedParameterizedType annotatedReturnType = (AnnotatedParameterizedType)method.getAnnotatedReturnType();
        ParameterizedType type = (ParameterizedType)annotatedReturnType.getType();
        this.sqlTypeParser = Objects.requireNonNull(sqlTypeParser);
        Type inputWrapperType = type.getActualTypeArguments()[0];
        boolean isMultipleArgs = TUPLE_TYPES.contains((Object)UdafTypes.getRawType(inputWrapperType));
        this.inputTypes = isMultipleArgs ? ((ParameterizedType)inputWrapperType).getActualTypeArguments() : new Type[]{inputWrapperType};
        if (UdafTypes.countVariadic(this.inputTypes, method) > 1L) {
            throw new KsqlException("A UDAF and its factory can have at most one variadic argument");
        }
        this.variadicColIndex = UdafTypes.indexOfType(this.inputTypes, VARIADIC_TYPE);
        if (method.isVarArgs()) {
            this.isVariadic = true;
        } else if (isMultipleArgs && this.variadicColIndex > -1) {
            this.isVariadic = true;
            this.inputTypes[this.variadicColIndex] = ((ParameterizedType)this.inputTypes[this.variadicColIndex]).getActualTypeArguments()[0];
        } else {
            if (this.variadicColIndex > -1) {
                throw new KsqlException("Variadic column arguments are only allowed inside tuples");
            }
            this.isVariadic = false;
        }
        boolean hasMultipleObjectArgs = UdafTypes.countTypes(this.inputTypes, Object.class) > 1L;
        int indexOfFirstObj = UdafTypes.indexOfType(this.inputTypes, Object.class);
        boolean bl = objArgIsNotVariadic = indexOfFirstObj >= 0 && indexOfFirstObj != this.variadicColIndex;
        if (hasMultipleObjectArgs || objArgIsNotVariadic) {
            throw new KsqlException("The Object type can only be used as a variadic column argument");
        }
        this.aggregateType = type.getActualTypeArguments()[1];
        this.outputType = type.getActualTypeArguments()[2];
        this.literalParams = FunctionLoaderUtils.createParameters(method, functionName.text(), sqlTypeParser);
        this.validateTypes(this.inputTypes, this.variadicColIndex);
        this.validateType(this.aggregateType, false);
        this.validateType(this.outputType, false);
    }

    List<ParameterInfo> getInputSchema(String[] inSchemas) {
        ArrayList<ParamType> paramTypes = new ArrayList<ParamType>();
        for (int paramIndex2 = 0; paramIndex2 < this.inputTypes.length; ++paramIndex2) {
            Type inputType = this.inputTypes[paramIndex2];
            String schema = paramIndex2 < inSchemas.length ? inSchemas[paramIndex2] : "";
            Objects.requireNonNull(schema);
            UdafTypes.validateStructAnnotation(inputType, schema, "paramSchema");
            Object paramType = paramIndex2 == this.variadicColIndex ? ArrayType.of((ParamType)this.getSchemaFromType(inputType, schema, true)) : this.getSchemaFromType(inputType, schema, false);
            paramTypes.add((ParamType)paramType);
        }
        List paramInfos = IntStream.range(0, paramTypes.size()).mapToObj(paramIndex -> {
            ParamType paramType = (ParamType)paramTypes.get(paramIndex);
            return new ParameterInfo("val" + (paramIndex + 1), paramType, "", paramIndex == this.variadicColIndex);
        }).collect(Collectors.toList());
        return ImmutableList.builder().addAll(paramInfos).addAll(this.literalParams).build();
    }

    ParamType getAggregateSchema(String aggSchema) {
        UdafTypes.validateStructAnnotation(this.aggregateType, aggSchema, "aggregateSchema");
        return this.getSchemaFromType(this.aggregateType, aggSchema, false);
    }

    ParamType getOutputSchema(String outSchema) {
        UdafTypes.validateStructAnnotation(this.outputType, outSchema, "returnSchema");
        return this.getSchemaFromType(this.outputType, outSchema, false);
    }

    boolean isVariadic() {
        return this.isVariadic;
    }

    List<ParameterInfo> literalParams() {
        return ImmutableList.copyOf(this.literalParams);
    }

    private void validateType(Type t, boolean isVariadic) {
        if (!(t instanceof TypeVariable) && UdafTypes.isUnsupportedType((Class)UdafTypes.getRawType(t), isVariadic)) {
            throw new KsqlException(String.format(this.invalidClassErrorMsg, t));
        }
    }

    private void validateTypes(Type[] types, int variadicColIndex) {
        for (int index = 0; index < types.length; ++index) {
            this.validateType(types[index], index == variadicColIndex);
        }
    }

    private static long countVariadic(Type[] types, Method factory) {
        long count = UdafTypes.countTypes(types, VARIADIC_TYPE);
        if (factory.isVarArgs()) {
            ++count;
        }
        return count;
    }

    private static long countTypes(Type[] types, Type matchType) {
        return Arrays.stream(types).filter(type -> UdafTypes.getRawType(type).equals(matchType)).count();
    }

    private static int indexOfType(Type[] types, Type matchType) {
        return IntStream.range(0, types.length).filter(index -> UdafTypes.getRawType(types[index]).equals(matchType)).findFirst().orElse(-1);
    }

    private static void validateStructAnnotation(Type type, String schema, String msg) {
        if (type.equals(Struct.class) && schema.isEmpty()) {
            throw new KsqlException("Must specify '" + msg + "' for STRUCT parameter in @UdafFactory or implement getAggregateSqlType()/getReturnSqlType().");
        }
    }

    private ParamType getSchemaFromType(Type type, String schema, boolean isVariadic) {
        if (schema.isEmpty()) {
            return isVariadic ? UdfUtil.getVarArgsSchemaFromType((Type)type) : UdfUtil.getSchemaFromType((Type)type);
        }
        return SchemaConverters.sqlToFunctionConverter().toFunctionType(this.sqlTypeParser.parse(schema).getSqlType());
    }

    private static Type getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType();
        }
        return type;
    }

    private static boolean isUnsupportedType(Class<?> type, boolean allowObject) {
        return !(SUPPORTED_TYPES.contains(type) || type.isArray() && SUPPORTED_TYPES.contains(type.getComponentType()) || !SUPPORTED_TYPES.stream().noneMatch(supported -> supported.isAssignableFrom(type)) || allowObject && type.equals(Object.class));
    }

    static void checkSupportedType(Method method, Class<?> type) {
        if (UdafTypes.isUnsupportedType(type, false)) {
            throw new KsqlException(String.format("Type %s is not supported by UDF methods. Supported types %s. method=%s, class=%s", type, SUPPORTED_TYPES, method.getName(), method.getDeclaringClass()));
        }
    }
}

