/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.util.KsqlException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class UdfClassLoader
extends URLClassLoader {
    private static final Logger logger = LogManager.getLogger(URLClassLoader.class);
    private final Predicate<String> blacklist;
    private final Path path;

    private UdfClassLoader(Path path, URL[] urls, ClassLoader parent, Predicate<String> blacklist) {
        super(urls, parent);
        this.blacklist = Objects.requireNonNull(blacklist, "blacklist can't be null");
        this.path = Objects.requireNonNull(path, "path can't be null");
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.blacklist.test(name)) {
            throw new ClassNotFoundException("The requested class is not permitted to be used from a udf. Class " + name);
        }
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            try {
                if (this.shouldLoadFromChild(name)) {
                    clazz = this.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                logger.trace("Class {} not found in {} using parent classloader", (Object)name, (Object)this.path);
            }
        }
        if (clazz == null) {
            clazz = super.loadClass(name, false);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean shouldLoadFromChild(String name) {
        return !name.startsWith("io.confluent") && !name.startsWith("org.apache.kafka");
    }

    static UdfClassLoader newClassLoader(Path path, ClassLoader parentClassLoader, Predicate<String> blacklist) {
        logger.debug("creating UdfClassLoader for {}", (Object)path);
        return AccessController.doPrivileged(() -> new UdfClassLoader(path, UdfClassLoader.toUrl(path), parentClassLoader, blacklist));
    }

    private static URL[] toUrl(Path path) {
        try {
            return new URL[]{path.toUri().toURL()};
        }
        catch (MalformedURLException e) {
            throw new KsqlException("Unable to create classloader for path:" + String.valueOf(path), (Throwable)e);
        }
    }

    Path getJarPath() {
        return this.path;
    }
}

