/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.function.FunctionInvoker;
import io.confluent.ksql.function.FunctionLoaderUtils;
import io.confluent.ksql.function.FunctionMetrics;
import io.confluent.ksql.function.KsqlScalarFunction;
import io.confluent.ksql.function.MutableFunctionRegistry;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.SchemaProvider;
import io.confluent.ksql.function.UdfFactory;
import io.confluent.ksql.function.UdfMetricProducer;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.function.udf.PluggableUdf;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import io.confluent.ksql.security.ExtensionSecurityManager;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UdfLoader {
    private static final Logger LOGGER = LogManager.getLogger(UdfLoader.class);
    private final MutableFunctionRegistry functionRegistry;
    private final Optional<Metrics> metrics;
    private final SqlTypeParser typeParser;
    private final boolean throwExceptionOnLoadFailure;

    public UdfLoader(MutableFunctionRegistry functionRegistry, Optional<Metrics> metrics, SqlTypeParser typeParser, boolean throwExceptionOnLoadFailure) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        this.typeParser = Objects.requireNonNull(typeParser, "typeParser");
        this.throwExceptionOnLoadFailure = throwExceptionOnLoadFailure;
    }

    @VisibleForTesting
    void loadUdfFromClass(Class<?> ... udfClasses) {
        for (Class<?> theClass : udfClasses) {
            this.loadUdfFromClass(theClass, "internal");
        }
    }

    @VisibleForTesting
    public void loadUdfFromClass(Class<?> theClass, String path) {
        UdfDescription udfDescriptionAnnotation = theClass.getAnnotation(UdfDescription.class);
        if (udfDescriptionAnnotation == null) {
            throw new KsqlException(String.format("Cannot load class %s. Classes containing UDFs mustbe annotated with @UdfDescription.", theClass.getName()));
        }
        String functionName = udfDescriptionAnnotation.name();
        String sensorName = "ksql-udf-" + functionName;
        Class<PluggableUdf> udfClass = this.metrics.map(m -> UdfMetricProducer.class).orElse(PluggableUdf.class);
        FunctionMetrics.initInvocationSensor(this.metrics, sensorName, "ksql-udf", functionName + " udf");
        UdfFactory factory = new UdfFactory(udfClass, new UdfMetadata(udfDescriptionAnnotation.name(), udfDescriptionAnnotation.description(), udfDescriptionAnnotation.author(), udfDescriptionAnnotation.version(), udfDescriptionAnnotation.category(), path));
        this.functionRegistry.ensureFunctionFactory(factory);
        for (Method method : theClass.getMethods()) {
            KsqlScalarFunction function;
            Udf udfAnnotation = method.getAnnotation(Udf.class);
            if (udfAnnotation == null) continue;
            try {
                function = this.createFunction(theClass, udfDescriptionAnnotation, udfAnnotation, method, path, sensorName, udfClass);
            }
            catch (KsqlException e) {
                if (this.throwExceptionOnLoadFailure) {
                    throw e;
                }
                LOGGER.warn("Failed to add UDF to the MetaStore. name={} method={}", (Object)udfDescriptionAnnotation.name(), (Object)method, (Object)e);
                continue;
            }
            factory.addFunction(function);
        }
    }

    private KsqlScalarFunction createFunction(Class theClass, UdfDescription udfDescriptionAnnotation, Udf udfAnnotation, Method method, String path, String sensorName, Class<? extends Kudf> udfClass) {
        FunctionLoaderUtils.instantiateFunctionInstance(method.getDeclaringClass(), udfDescriptionAnnotation.name());
        FunctionInvoker invoker = FunctionLoaderUtils.createFunctionInvoker(method);
        String functionName = udfDescriptionAnnotation.name();
        LOGGER.debug("Adding function {} for method {}", (Object)functionName, (Object)method);
        List<ParameterInfo> parameters = FunctionLoaderUtils.createParameters(method, functionName, this.typeParser);
        ParamType javaReturnSchema = FunctionLoaderUtils.getReturnType(method, udfAnnotation.schema(), this.typeParser);
        SchemaProvider schemaProviderFunction = FunctionLoaderUtils.handleUdfReturnSchema(theClass, javaReturnSchema, udfAnnotation.schema(), this.typeParser, udfAnnotation.schemaProvider(), udfDescriptionAnnotation.name(), method.isVarArgs());
        return KsqlScalarFunction.create((SchemaProvider)schemaProviderFunction, (ParamType)javaReturnSchema, parameters, (FunctionName)FunctionName.of((String)functionName.toUpperCase()), udfClass, this.getUdfFactory(method, udfDescriptionAnnotation, functionName, invoker, sensorName), (String)udfAnnotation.description(), (String)path, (boolean)method.isVarArgs());
    }

    private Function<KsqlConfig, Kudf> getUdfFactory(Method method, UdfDescription udfDescriptionAnnotation, String functionName, FunctionInvoker invoker, String sensorName) {
        return ksqlConfig -> {
            Object actualUdf = FunctionLoaderUtils.instantiateFunctionInstance(method.getDeclaringClass(), udfDescriptionAnnotation.name());
            if (actualUdf instanceof Configurable) {
                ExtensionSecurityManager.INSTANCE.pushInUdf();
                try {
                    ((Configurable)actualUdf).configure(ksqlConfig.getKsqlFunctionsConfigProps(functionName));
                }
                finally {
                    ExtensionSecurityManager.INSTANCE.popOutUdf();
                }
            }
            PluggableUdf theUdf = new PluggableUdf(invoker, actualUdf);
            return this.metrics.map(m -> new UdfMetricProducer(m.getSensor(sensorName), theUdf, Time.SYSTEM)).orElse(theUdf);
        };
    }
}

