/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.FunctionInvoker;
import io.confluent.ksql.function.FunctionLoaderUtils;
import io.confluent.ksql.function.FunctionMetrics;
import io.confluent.ksql.function.KsqlTableFunction;
import io.confluent.ksql.function.MutableFunctionRegistry;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.SchemaProvider;
import io.confluent.ksql.function.TableFunctionFactory;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.function.udf.PluggableUdf;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.function.udtf.Udtf;
import io.confluent.ksql.function.udtf.UdtfDescription;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import io.confluent.ksql.util.KsqlException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UdtfLoader {
    private static final Logger LOGGER = LogManager.getLogger(UdtfLoader.class);
    private final MutableFunctionRegistry functionRegistry;
    private final Optional<Metrics> metrics;
    private final SqlTypeParser typeParser;
    private final boolean throwExceptionOnLoadFailure;

    public UdtfLoader(MutableFunctionRegistry functionRegistry, Optional<Metrics> metrics, SqlTypeParser typeParser, boolean throwExceptionOnLoadFailure) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        this.typeParser = Objects.requireNonNull(typeParser, "typeParser");
        this.throwExceptionOnLoadFailure = throwExceptionOnLoadFailure;
    }

    public void loadUdtfFromClass(Class<?> theClass, String path) {
        UdtfDescription udtfDescriptionAnnotation = theClass.getAnnotation(UdtfDescription.class);
        if (udtfDescriptionAnnotation == null) {
            throw new KsqlException(String.format("Cannot load class %s. Classes containing UDTFs mustbe annotated with @UdtfDescription.", theClass.getName()));
        }
        String functionName = udtfDescriptionAnnotation.name();
        String sensorName = "ksql-udtf-" + functionName;
        FunctionMetrics.initInvocationSensor(this.metrics, sensorName, "ksql-udtf", functionName + " udtf");
        UdfMetadata metadata = new UdfMetadata(udtfDescriptionAnnotation.name(), udtfDescriptionAnnotation.description(), udtfDescriptionAnnotation.author(), udtfDescriptionAnnotation.version(), udtfDescriptionAnnotation.category(), path);
        TableFunctionFactory factory = new TableFunctionFactory(metadata);
        for (Method method : theClass.getMethods()) {
            if (method.getAnnotation(Udtf.class) == null) continue;
            Udtf annotation = method.getAnnotation(Udtf.class);
            try {
                if (method.getReturnType() != List.class) {
                    throw new KsqlException(String.format("UDTF functions must return a List. Class %s Method %s", theClass.getName(), method.getName()));
                }
                Type ret = method.getGenericReturnType();
                if (!(ret instanceof ParameterizedType)) {
                    throw new KsqlException(String.format("UDTF functions must return a parameterized List. Class %s Method %s", theClass.getName(), method.getName()));
                }
                Type typeArg = ((ParameterizedType)ret).getActualTypeArguments()[0];
                ParamType returnType = FunctionLoaderUtils.getReturnType(method, typeArg, annotation.schema(), this.typeParser);
                List<ParameterInfo> parameters = FunctionLoaderUtils.createParameters(method, functionName, this.typeParser);
                KsqlTableFunction tableFunction = this.createTableFunction(method, FunctionName.of((String)functionName), returnType, parameters, annotation.description(), annotation);
                factory.addFunction(tableFunction);
            }
            catch (KsqlException e) {
                if (this.throwExceptionOnLoadFailure) {
                    throw e;
                }
                LOGGER.warn("Failed to add UDTF to the MetaStore. name={} method={}", (Object)udtfDescriptionAnnotation.name(), (Object)method, (Object)e);
            }
        }
        this.functionRegistry.addTableFunctionFactory(factory);
    }

    private KsqlTableFunction createTableFunction(Method method, FunctionName functionName, ParamType outputType, List<ParameterInfo> parameters, String description, Udtf udtfAnnotation) {
        FunctionInvoker invoker = FunctionLoaderUtils.createFunctionInvoker(method);
        Object instance = FunctionLoaderUtils.instantiateFunctionInstance(method.getDeclaringClass(), description);
        SchemaProvider schemaProviderFunction = FunctionLoaderUtils.handleUdfReturnSchema(method.getDeclaringClass(), outputType, udtfAnnotation.schema(), this.typeParser, udtfAnnotation.schemaProvider(), functionName.text(), method.isVarArgs());
        return new KsqlTableFunction(schemaProviderFunction, functionName, outputType, parameters, description, (Kudf)new PluggableUdf(invoker, instance));
    }
}

