/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.offset;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udaf.Udaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import io.confluent.ksql.function.udaf.offset.KudafByOffsetUtils;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

@UdafDescription(name="LATEST_BY_OFFSET", description="This function returns the oldest N values for the column, computed by offset.", author="Confluent")
public final class LatestByOffset {
    static final String DESCRIPTION = "This function returns the oldest N values for the column, computed by offset.";
    static final AtomicLong sequence = new AtomicLong();

    private LatestByOffset() {
    }

    @UdafFactory(description="return the latest value of a column")
    public static <T> Udaf<T, Struct, T> latest() {
        return LatestByOffset.latest(true);
    }

    @UdafFactory(description="return the latest value of a column")
    public static <T> Udaf<T, Struct, T> latest(boolean ignoreNulls) {
        return LatestByOffset.latestT(ignoreNulls, LatestByOffset.getComparator(ignoreNulls));
    }

    @UdafFactory(description="return the latest N values of a column")
    public static <T> Udaf<T, List<Struct>, List<T>> latest(int latestN) {
        return LatestByOffset.latest(latestN, true);
    }

    @UdafFactory(description="return the latest N values of a column")
    public static <T> Udaf<T, List<Struct>, List<T>> latest(int latestN, boolean ignoreNulls) {
        return LatestByOffset.latestTN(latestN, ignoreNulls, LatestByOffset.getComparator(ignoreNulls));
    }

    @VisibleForTesting
    static <T> Struct createStruct(Schema schema, T val) {
        return KudafByOffsetUtils.createStruct(schema, LatestByOffset.generateSequence(), val);
    }

    private static long generateSequence() {
        return sequence.getAndIncrement();
    }

    @VisibleForTesting
    static <T> Udaf<T, Struct, T> latestT(final boolean ignoreNulls, final Comparator<Struct> comparator) {
        return new Udaf<T, Struct, T>(){
            Schema structSchema;
            SqlType aggregateType;
            SqlType returnType;

            public void initializeTypeArguments(List<SqlArgument> argTypeList) {
                this.returnType = argTypeList.get(0).getSqlTypeOrThrow();
                Schema connectType = SchemaConverters.sqlToConnectConverter().toConnectSchema(this.returnType);
                this.structSchema = KudafByOffsetUtils.buildSchema(connectType);
                this.aggregateType = SchemaConverters.connectToSqlConverter().toSqlType(this.structSchema);
            }

            public Optional<SqlType> getAggregateSqlType() {
                return Optional.of(this.aggregateType);
            }

            public Optional<SqlType> getReturnSqlType() {
                return Optional.of(this.returnType);
            }

            public Struct initialize() {
                return LatestByOffset.createStruct(this.structSchema, null);
            }

            public Struct aggregate(T current, Struct aggregate) {
                if (current == null && ignoreNulls) {
                    return aggregate;
                }
                return LatestByOffset.createStruct(this.structSchema, current);
            }

            public Struct merge(Struct aggOne, Struct aggTwo) {
                if (comparator.compare(aggOne, aggTwo) >= 0) {
                    return aggOne;
                }
                return aggTwo;
            }

            public T map(Struct agg) {
                return agg.get("VAL");
            }
        };
    }

    @VisibleForTesting
    static <T> Udaf<T, List<Struct>, List<T>> latestTN(final int latestN, final boolean ignoreNulls, Comparator<Struct> comparator) {
        if (latestN <= 0) {
            throw new KsqlFunctionException("latestN must be 1 or greater");
        }
        return new Udaf<T, List<Struct>, List<T>>(){
            Schema structSchema;
            SqlType aggregateType;
            SqlType returnType;

            public void initializeTypeArguments(List<SqlArgument> argTypeList) {
                SqlType inputType = argTypeList.get(0).getSqlTypeOrThrow();
                Schema connectType = SchemaConverters.sqlToConnectConverter().toConnectSchema(inputType);
                this.structSchema = KudafByOffsetUtils.buildSchema(connectType);
                this.aggregateType = SqlArray.of((SqlType)SchemaConverters.connectToSqlConverter().toSqlType(this.structSchema));
                this.returnType = SqlArray.of((SqlType)inputType);
            }

            public Optional<SqlType> getAggregateSqlType() {
                return Optional.of(this.aggregateType);
            }

            public Optional<SqlType> getReturnSqlType() {
                return Optional.of(this.returnType);
            }

            public List<Struct> initialize() {
                return new ArrayList<Struct>(latestN);
            }

            public List<Struct> aggregate(T current, List<Struct> aggregate) {
                if (current == null && ignoreNulls) {
                    return aggregate;
                }
                aggregate.add(LatestByOffset.createStruct(this.structSchema, current));
                int currentSize = aggregate.size();
                if (currentSize > latestN) {
                    return aggregate.subList(currentSize - latestN, currentSize);
                }
                return aggregate;
            }

            public List<Struct> merge(List<Struct> aggOne, List<Struct> aggTwo) {
                ArrayList<Struct> merged = new ArrayList<Struct>(aggOne.size() + aggTwo.size());
                merged.addAll(aggOne);
                merged.addAll(aggTwo);
                merged.sort(KudafByOffsetUtils.INTERMEDIATE_STRUCT_COMPARATOR);
                return merged.subList(0, Math.min(latestN, merged.size()));
            }

            public List<T> map(List<Struct> agg) {
                return agg.stream().map((? super T s) -> s.get("VAL")).collect(Collectors.toList());
            }
        };
    }

    private static Comparator<Struct> getComparator(boolean ignoreNulls) {
        if (ignoreNulls) {
            return KudafByOffsetUtils.INTERMEDIATE_STRUCT_COMPARATOR_IGNORE_NULLS;
        }
        return KudafByOffsetUtils.INTERMEDIATE_STRUCT_COMPARATOR;
    }
}

