/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.sum;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udaf.TableUdaf;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.Optional;

public class DecimalSumKudaf
implements TableUdaf<BigDecimal, BigDecimal, BigDecimal> {
    private SqlDecimal resultSchema;
    private MathContext context;
    private BigDecimal maxValue;
    private int precision;
    private int scale;
    private int digits;

    public void initializeTypeArguments(List<SqlArgument> argTypeList) {
        this.resultSchema = (SqlDecimal)argTypeList.get(0).getSqlTypeOrThrow();
        this.context = new MathContext(this.resultSchema.getPrecision());
        this.precision = this.resultSchema.getPrecision();
        this.scale = this.resultSchema.getScale();
        this.digits = this.resultSchema.getPrecision() - this.resultSchema.getScale();
        this.maxValue = BigDecimal.valueOf(Math.pow(10.0, this.digits));
    }

    public BigDecimal initialize() {
        return BigDecimal.ZERO;
    }

    public Optional<SqlType> getAggregateSqlType() {
        return Optional.of(this.resultSchema);
    }

    public Optional<SqlType> getReturnSqlType() {
        return Optional.of(this.resultSchema);
    }

    public BigDecimal aggregate(BigDecimal currentValue, BigDecimal aggregateValue) {
        if (currentValue == null) {
            return aggregateValue;
        }
        BigDecimal value = aggregateValue.add(currentValue, this.context);
        if (this.maxValue.compareTo(value.abs()) < 1) {
            throw new KsqlFunctionException(String.format("Numeric field overflow: A field with precision %d and scale %d must round to an absolute value less than 10^%d. Got %s", this.precision, this.scale, this.digits, value.toPlainString()));
        }
        return value;
    }

    public BigDecimal merge(BigDecimal aggOne, BigDecimal aggTwo) {
        return aggOne.add(aggTwo, this.context);
    }

    public BigDecimal map(BigDecimal agg) {
        return agg;
    }

    public BigDecimal undo(BigDecimal valueToUndo, BigDecimal aggregateValue) {
        if (valueToUndo == null) {
            return aggregateValue;
        }
        return aggregateValue.subtract(valueToUndo, this.context);
    }
}

