/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.sum;

import io.confluent.ksql.function.udaf.TableUdaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import io.confluent.ksql.function.udaf.sum.DecimalSumKudaf;
import io.confluent.ksql.function.udaf.sum.DoubleSumKudaf;
import io.confluent.ksql.function.udaf.sum.IntegerSumKudaf;
import io.confluent.ksql.function.udaf.sum.LongSumKudaf;
import java.math.BigDecimal;

@UdafDescription(name="SUM", description="Computes the sum for a key.", author="Confluent")
public abstract class SumKudaf<T>
implements TableUdaf<T, T, T> {
    public static final String DESCRIPTION = "Computes the sum for a key.";

    @UdafFactory(description="Computes the sum of decimal values for a key, resulting in a decimal with the same precision and scale.")
    public static TableUdaf<BigDecimal, BigDecimal, BigDecimal> createSumDecimal() {
        return new DecimalSumKudaf();
    }

    @UdafFactory(description="Computes the sum for a key.")
    public static TableUdaf<Double, Double, Double> createSumDouble() {
        return new DoubleSumKudaf();
    }

    @UdafFactory(description="Computes the sum for a key.")
    public static TableUdaf<Long, Long, Long> createSumLong() {
        return new LongSumKudaf();
    }

    @UdafFactory(description="Computes the sum for a key.")
    public static TableUdaf<Integer, Integer, Integer> createSumInt() {
        return new IntegerSumKudaf();
    }
}

