/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;

@UdfDescription(name="ARRAY_JOIN", category="ARRAY", description="joins the array elements into a flat string representation", author="Confluent")
public class ArrayJoin {
    private static final String DEFAULT_DELIMITER = ",";
    private static final Set<Class> KSQL_PRIMITIVES = ImmutableSet.of(Boolean.class, Integer.class, Long.class, Double.class, BigDecimal.class, String.class, (Object[])new Class[0]);

    @Udf
    public <T> String join(@UdfParameter(description="the array to join using the default delimiter ','") List<T> array) {
        return this.join(array, DEFAULT_DELIMITER);
    }

    @Udf
    public <T> String join(@UdfParameter(description="the array to join using the specified delimiter") List<T> array, @UdfParameter(description="the string to be used as element delimiter") String delimiter) {
        if (array == null) {
            return null;
        }
        StringJoiner sj = new StringJoiner(delimiter == null ? "" : delimiter);
        array.forEach(e -> ArrayJoin.processElement(e, sj));
        return sj.toString();
    }

    private static <T> void processElement(T element, StringJoiner joiner) {
        if (element != null && !KSQL_PRIMITIVES.contains(element.getClass())) {
            throw new KsqlFunctionException("error: hit element of type " + element.getClass().getTypeName() + " which is currently not supported");
        }
        ArrayJoin.handlePrimitiveType(element, joiner);
    }

    private static void handlePrimitiveType(Object element, StringJoiner joiner) {
        joiner.add(element != null ? element.toString() : null);
    }
}

