/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.List;

@UdfDescription(name="array_min", category="ARRAY", description="Return the minimum value from within an array of primitive values, according to their natural sort order. If the array is NULL, or contains only NULLs, return NULL.")
public class ArrayMin {
    @Udf
    public <T extends Comparable<? super T>> T arrayMin(@UdfParameter(description="Array of values from which to find the minimum") List<T> input) {
        if (input == null) {
            return null;
        }
        Comparable candidate = null;
        for (Comparable thisVal : input) {
            if (thisVal == null) continue;
            if (candidate == null) {
                candidate = thisVal;
                continue;
            }
            if (thisVal.compareTo(candidate) >= 0) continue;
            candidate = thisVal;
        }
        return (T)candidate;
    }
}

