/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@UdfDescription(name="array_remove", category="ARRAY", description="Removes all the elements equal to a specific value from an array. Returns NULL if the input array is NULL.")
public class ArrayRemove {
    @Udf
    public <T> List<T> remove(@UdfParameter(description="Array of values") List<T> array, @UdfParameter(description="Value to remove") T victim) {
        if (array == null) {
            return null;
        }
        return array.stream().filter(el -> !Objects.equals(el, victim)).collect(Collectors.toList());
    }
}

