/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import com.google.common.collect.Lists;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@UdfDescription(name="array_sort", category="ARRAY", description="Sort an array of primitive values, according to their natural sort order. Any NULLs in the array will be placed at the end.")
public class ArraySort {
    private static final List<String> SORT_DIRECTION_ASC = Lists.newArrayList((Object[])new String[]{"ASC", "ASCENDING"});
    private static final List<String> SORT_DIRECTION_DESC = Lists.newArrayList((Object[])new String[]{"DESC", "DESCENDING"});

    @Udf
    public <T extends Comparable<? super T>> List<T> arraySortDefault(@UdfParameter(description="The array to sort") List<T> input) {
        return this.arraySortWithDirection(input, "ASC");
    }

    @Udf
    public <T extends Comparable<? super T>> List<T> arraySortWithDirection(@UdfParameter(description="The array to sort") List<T> input, @UdfParameter(description="Marks the end of the series (inclusive)") String direction) {
        if (input == null || direction == null) {
            return null;
        }
        if (SORT_DIRECTION_ASC.contains(direction.toUpperCase())) {
            input.sort(Comparator.nullsLast(Comparator.naturalOrder()));
        } else if (SORT_DIRECTION_DESC.contains(direction.toUpperCase())) {
            input.sort(Comparator.nullsLast(Collections.reverseOrder()));
        } else {
            return null;
        }
        return input;
    }
}

