/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import com.google.common.collect.Sets;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

@UdfDescription(name="array_union", category="ARRAY", description="Returns an array of all the distinct elements from both input arrays, or NULL if either array is NULL.")
public class ArrayUnion {
    @Udf
    public <T> List<T> union(@UdfParameter(description="First array of values") List<T> left, @UdfParameter(description="Second array of values") List<T> right) {
        if (left == null || right == null) {
            return null;
        }
        LinkedHashSet combined = Sets.newLinkedHashSet(left);
        combined.addAll(right);
        return Arrays.asList(combined.toArray());
    }
}

