/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

@UdfDescription(name="ENTRIES", category="MAP", description="Construct an array from the entries in a map.The array can be optionally sorted on the keys.", author="Confluent")
public class Entries {
    private static final Schema INT_STRUCT_SCHEMA = Entries.buildStructSchema(Schema.OPTIONAL_INT32_SCHEMA);
    private static final Schema BIGINT_STRUCT_SCHEMA = Entries.buildStructSchema(Schema.OPTIONAL_INT64_SCHEMA);
    private static final Schema DOUBLE_STRUCT_SCHEMA = Entries.buildStructSchema(Schema.OPTIONAL_FLOAT64_SCHEMA);
    private static final Schema BOOLEAN_STRUCT_SCHEMA = Entries.buildStructSchema(Schema.OPTIONAL_BOOLEAN_SCHEMA);
    private static final Schema STRING_STRUCT_SCHEMA = Entries.buildStructSchema(Schema.OPTIONAL_STRING_SCHEMA);
    private static final String KEY_FIELD_NAME = "K";
    private static final String VALUE_FIELD_NAME = "V";

    private static Schema buildStructSchema(Schema valueSchema) {
        return SchemaBuilder.struct().field(KEY_FIELD_NAME, Schema.OPTIONAL_STRING_SCHEMA).field(VALUE_FIELD_NAME, valueSchema).optional().build();
    }

    @Udf(schema="ARRAY<STRUCT<K STRING, V INT>>")
    public List<Struct> entriesInt(@UdfParameter(description="The map to create entries from") Map<String, Integer> map, @UdfParameter(description="If true then the resulting entries are sorted by key") boolean sorted) {
        return this.entries(map, INT_STRUCT_SCHEMA, sorted);
    }

    @Udf(schema="ARRAY<STRUCT<K STRING, V BIGINT>>")
    public List<Struct> entriesBigInt(@UdfParameter(description="The map to create entries from") Map<String, Long> map, @UdfParameter(description="If true then the resulting entries are sorted by key") boolean sorted) {
        return this.entries(map, BIGINT_STRUCT_SCHEMA, sorted);
    }

    @Udf(schema="ARRAY<STRUCT<K STRING, V DOUBLE>>")
    public List<Struct> entriesDouble(@UdfParameter(description="The map to create entries from") Map<String, Double> map, @UdfParameter(description="If true then the resulting entries are sorted by key") boolean sorted) {
        return this.entries(map, DOUBLE_STRUCT_SCHEMA, sorted);
    }

    @Udf(schema="ARRAY<STRUCT<K STRING, V BOOLEAN>>")
    public List<Struct> entriesBoolean(@UdfParameter(description="The map to create entries from") Map<String, Boolean> map, @UdfParameter(description="If true then the resulting entries are sorted by key") boolean sorted) {
        return this.entries(map, BOOLEAN_STRUCT_SCHEMA, sorted);
    }

    @Udf(schema="ARRAY<STRUCT<K STRING, V STRING>>")
    public List<Struct> entriesString(@UdfParameter(description="The map to create entries from") Map<String, String> map, @UdfParameter(description="If true then the resulting entries are sorted by key") boolean sorted) {
        return this.entries(map, STRING_STRUCT_SCHEMA, sorted);
    }

    private <T> List<Struct> entries(Map<String, T> map, Schema structSchema, boolean sorted) {
        if (map == null) {
            return null;
        }
        ArrayList<Struct> structs = new ArrayList<Struct>(map.size());
        Collection<Map.Entry<String, T>> entries = map.entrySet();
        if (sorted) {
            ArrayList<Map.Entry<String, T>> list = new ArrayList<Map.Entry<String, T>>(entries);
            list.sort(Map.Entry.comparingByKey());
            entries = list;
        }
        for (Map.Entry entry : entries) {
            Struct struct = new Struct(structSchema);
            struct.put(KEY_FIELD_NAME, entry.getKey()).put(VALUE_FIELD_NAME, entry.getValue());
            structs.add(struct);
        }
        return structs;
    }
}

