/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.util.timestamp.StringToTimestampParser;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.concurrent.ExecutionException;

@UdfDescription(name="parse_timestamp", category="DATE / TIME", author="Confluent", description="Converts a string representation of a date in the given format into a TIMESTAMP value.")
public class ParseTimestamp {
    private final LoadingCache<String, StringToTimestampParser> parsers = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(StringToTimestampParser::new));

    @Udf(description="Converts a string representation of a date in the given format into the TIMESTAMP value. Single quotes in the timestamp format can be escaped with '', for example: 'yyyy-MM-dd''T''HH:mm:ssX'.")
    public Timestamp parseTimestamp(@UdfParameter(description="The string representation of a date.") String formattedTimestamp, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern) {
        return this.parseTimestamp(formattedTimestamp, formatPattern, ZoneId.of("GMT").getId());
    }

    @Udf(description="Converts a string representation of a date at the given time zone in the given format into the TIMESTAMP value. Single quotes in the timestamp format can be escaped with '', for example: 'yyyy-MM-dd''T''HH:mm:ssX'.")
    public Timestamp parseTimestamp(@UdfParameter(description="The string representation of a date.") String formattedTimestamp, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern, @UdfParameter(description=" timeZone is a java.util.TimeZone ID format, for example: \"UTC\", \"America/Los_Angeles\", \"PST\", \"Europe/London\"") String timeZone) {
        if (formattedTimestamp == null || formatPattern == null || timeZone == null) {
            return null;
        }
        try {
            StringToTimestampParser timestampParser = (StringToTimestampParser)this.parsers.get((Object)formatPattern);
            ZoneId zoneId = ZoneId.of(timeZone);
            return timestampParser.parseToTimestamp(formattedTimestamp, zoneId);
        }
        catch (RuntimeException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to parse timestamp '" + formattedTimestamp + "' at timezone '" + timeZone + "' with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

