/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Time;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

@UdfDescription(name="timesub", category="DATE / TIME", author="Confluent", description="Subtracts a duration from a TIME value.")
public class TimeSub {
    @Udf(description="Subtracts a duration from a time")
    public Time timeSub(@UdfParameter(description="A unit of time, for example SECOND or HOUR") TimeUnit unit, @UdfParameter(description="An integer number of intervals to subtract") Integer interval, @UdfParameter(description="A TIME value.") Time time) {
        if (unit == null || interval == null || time == null) {
            return null;
        }
        long nanoResult = LocalTime.ofNanoOfDay(time.getTime() * 1000000L).minus(unit.toNanos(interval.intValue()), ChronoUnit.NANOS).toNanoOfDay();
        return new Time(TimeUnit.NANOSECONDS.toMillis(nanoResult));
    }
}

