/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import java.sql.Date;
import java.time.LocalDate;
import java.util.concurrent.TimeUnit;

@UdfDescription(name="unix_date", category="DATE / TIME", description="Returns the current number of days for the system since 1970-01-01 00:00:00 UTC/GMT.", author="Confluent")
public class UnixDate {
    @Udf(description="Returns the current number of days for the system since 1970-01-01 00:00:00 UTC/GMT.")
    public int unixDate() {
        return (int)LocalDate.now().toEpochDay();
    }

    @Udf(description="Returns the current number of days since 1970-01-01 00:00:00 UTC/GMT represented by the given date.")
    public Integer unixDate(Date date) {
        if (date == null) {
            return null;
        }
        return (int)TimeUnit.MILLISECONDS.toDays(date.getTime());
    }
}

