/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.json.UdfJsonMapper;

@UdfDescription(name="JSON_ARRAY_LENGTH", category="JSON", description="Given a string, parses it as a JSON value and returns the length of the top-level array. Returns NULL if the string can't be interpreted as a JSON array, for example, when the string is `NULL` or it does not contain valid JSON, or the JSON value is not an array.", author="Confluent")
public class JsonArrayLength {
    @Udf
    public Integer length(@UdfParameter String jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        JsonNode node = UdfJsonMapper.parseJson(jsonArray);
        if (node.isMissingNode() || !node.isArray()) {
            return null;
        }
        return node.size();
    }
}

