/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.UdfSchemaProvider;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.util.List;

@UdfDescription(name="Abs", category="MATHEMATICAL", description="Returns the absolute value of its argument. If the argument is not negative, the argument is returned. If the argument is negative, the negation of the argument is returned.", author="Confluent")
public class Abs {
    static final String DESCRIPTION = "Returns the absolute value of its argument. If the argument is not negative, the argument is returned. If the argument is negative, the negation of the argument is returned.";

    @Udf
    public Integer abs(@UdfParameter Integer val) {
        return val == null ? null : Integer.valueOf(Math.abs(val));
    }

    @Udf
    public Long abs(@UdfParameter Long val) {
        return val == null ? null : Long.valueOf(Math.abs(val));
    }

    @Udf
    public Double abs(@UdfParameter Double val) {
        return val == null ? null : Double.valueOf(Math.abs(val));
    }

    @Udf(schemaProvider="absDecimalProvider")
    public BigDecimal abs(@UdfParameter BigDecimal val) {
        return val == null ? null : val.abs();
    }

    @UdfSchemaProvider
    public SqlType absDecimalProvider(List<SqlArgument> params) {
        SqlType s = params.get(0).getSqlTypeOrThrow();
        if (s.baseType() != SqlBaseType.DECIMAL) {
            throw new KsqlException("The schema provider method for Abs expects a BigDecimal parametertype");
        }
        return s;
    }
}

