/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="acos", category="MATHEMATICAL", author="Confluent", description="The inverse (arc) cosine of a value. The returned value is in radians.")
public class Acos {
    @Udf(description="Returns the inverse (arc) cosine of an INT value")
    public Double acos(@UdfParameter(value="value", description="The value to get the inverse cosine of.") Integer value) {
        return this.acos(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the inverse (arc) cosine of a BIGINT value")
    public Double acos(@UdfParameter(value="value", description="The value to get the inverse cosine of.") Long value) {
        return this.acos(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the inverse (arc) cosine of a DOUBLE value")
    public Double acos(@UdfParameter(value="value", description="The value to get the inverse cosine of.") Double value) {
        return value == null ? null : Double.valueOf(Math.acos(value));
    }
}

