/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="asin", category="MATHEMATICAL", author="Confluent", description="The inverse (arc) sine of a value. The returned value is in radians.")
public class Asin {
    @Udf(description="Returns the inverse (arc) sine of an INT value")
    public Double asin(@UdfParameter(value="value", description="The value to get the inverse sine of.") Integer value) {
        return this.asin(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the inverse (arc) sine of a BIGINT value")
    public Double asin(@UdfParameter(value="value", description="The value to get the inverse sine of.") Long value) {
        return this.asin(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the inverse (arc) sine of a DOUBLE value")
    public Double asin(@UdfParameter(value="value", description="The value to get the inverse sine of.") Double value) {
        return value == null ? null : Double.valueOf(Math.asin(value));
    }
}

