/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="cos", category="MATHEMATICAL", author="Confluent", description="The cosine of a value.")
public class Cos {
    @Udf(description="Returns the cosine of an INT value")
    public Double cos(@UdfParameter(value="value", description="The value in radians to get the cosine of.") Integer value) {
        return this.cos(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the cosine of a BIGINT value")
    public Double cos(@UdfParameter(value="value", description="The value in radians to get the cosine of.") Long value) {
        return this.cos(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the cosine of a DOUBLE value")
    public Double cos(@UdfParameter(value="value", description="The value in radians to get the cosine of.") Double value) {
        return value == null ? null : Double.valueOf(Math.cos(value));
    }
}

