/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="degrees", category="MATHEMATICAL", author="Confluent", description="Converts a value in radians to a value in degrees.")
public class Degrees {
    @Udf(description="Converts an INT value in radians to a value in degrees")
    public Double degrees(@UdfParameter(value="value", description="The value in radians to convert to degrees.") Integer value) {
        return this.degrees(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Converts a BIGINT value in radians to a value in degrees")
    public Double degrees(@UdfParameter(value="value", description="The value in radians to convert to degrees.") Long value) {
        return this.degrees(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Converts a DOUBLE value in radians to a value in degrees")
    public Double degrees(@UdfParameter(value="value", description="The value in radians to convert to degrees.") Double value) {
        return value == null ? null : Double.valueOf(Math.toDegrees(value));
    }
}

